# Tiktok\EventApi

All URIs are relative to https://open-api.tiktokglobalshop.com, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**deleteWebhook()**](EventApi.md#deleteWebhook) | **DELETE** /event/202309/webhooks | Delete Shop Webhook |
| [**getWebhooks()**](EventApi.md#getWebhooks) | **GET** /event/202309/webhooks | Get Shop Webhooks |
| [**updateWebhook()**](EventApi.md#updateWebhook) | **PUT** /event/202309/webhooks | Update Shop Webhook |


## `deleteWebhook()`

```php
deleteWebhook($shop_cipher, $webhook): \Tiktok\Model\Response
```

Delete Shop Webhook

This API deletes the shop's webhook URL for a specific event type. Regardless of whether webhook is configured or not, the result will return success.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\EventApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$shop_cipher = 'shop_cipher_example'; // string | Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response.
$webhook = new \Tiktok\Model\Webhook(); // \Tiktok\Model\Webhook

try {
    $result = $apiInstance->deleteWebhook($shop_cipher, $webhook);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EventApi->deleteWebhook: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **shop_cipher** | **string**| Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. | |
| **webhook** | [**\Tiktok\Model\Webhook**](../Model/Webhook.md)|  | [optional] |

### Return type

[**\Tiktok\Model\Response**](../Model/Response.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getWebhooks()`

```php
getWebhooks($shop_cipher): \Tiktok\Model\WebhooksResponse
```

Get Shop Webhooks

This API retrieves the shop's webhooks callback URL for all event types

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\EventApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$shop_cipher = 'shop_cipher_example'; // string | Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response.

try {
    $result = $apiInstance->getWebhooks($shop_cipher);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EventApi->getWebhooks: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **shop_cipher** | **string**| Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. | |

### Return type

[**\Tiktok\Model\WebhooksResponse**](../Model/WebhooksResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateWebhook()`

```php
updateWebhook($shop_cipher, $webhook): \Tiktok\Model\Response
```

Update Shop Webhook

This API updates the shop's webhook callback URL for a specific event type.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\EventApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$shop_cipher = 'shop_cipher_example'; // string | Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response.
$webhook = new \Tiktok\Model\Webhook(); // \Tiktok\Model\Webhook

try {
    $result = $apiInstance->updateWebhook($shop_cipher, $webhook);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling EventApi->updateWebhook: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **shop_cipher** | **string**| Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. | |
| **webhook** | [**\Tiktok\Model\Webhook**](../Model/Webhook.md)|  | [optional] |

### Return type

[**\Tiktok\Model\Response**](../Model/Response.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
