# Tiktok\AuthorizationApi

All URIs are relative to https://open-api.tiktokglobalshop.com, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**getShops()**](AuthorizationApi.md#getShops) | **GET** /authorization/202309/shops | Get Authorized Shops |


## `getShops()`

```php
getShops(): \Tiktok\Model\ShopsResponse
```

Get Authorized Shops

In cross-border scenarios, sellers may have multiple shops. Not all of these shops may be authorized by the developer for API access (authorized to be managed by apps or solutions in the TikTok Shop App Marketplace). Use this API to check which shops are authorized to be serviced by TikTok Shop APIs.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\AuthorizationApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->getShops();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->getShops: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Tiktok\Model\ShopsResponse**](../Model/ShopsResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
