# OpenAPIClient-php

See https://partner.tiktokshop.com/docv2/page/656559fcf4488c02dfe8ce82

TikTok Shop provides a comprehensive range of APIs known as TTS API, which allows TTS developers access to user data within the app, including catalogs, orders, shipments, payments, and more. Leveraging the capabilities of the TTS API, developers can create apps that extend Seller Center's existing functionalities. These apps can enhance product catalog listings, streamline order fulfillment, minimize operational burdens, and accelerate customer interactions


## Installation & Usage

### Requirements

PHP 7.4 and later.
Should also work with PHP 8.0.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/tiktok.git"
    }
  ],
  "require": {
    "talisman/tiktok": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');




$apiInstance = new Tiktok\Api\AuthorizationApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->getShops();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->getShops: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://open-api.tiktokglobalshop.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthorizationApi* | [**getShops**](docs/Api/AuthorizationApi.md#getshops) | **GET** /authorization/202309/shops | Get Authorized Shops
*EventApi* | [**deleteWebhook**](docs/Api/EventApi.md#deletewebhook) | **DELETE** /event/202309/webhooks | Delete Shop Webhook
*EventApi* | [**getWebhooks**](docs/Api/EventApi.md#getwebhooks) | **GET** /event/202309/webhooks | Get Shop Webhooks
*EventApi* | [**updateWebhook**](docs/Api/EventApi.md#updatewebhook) | **PUT** /event/202309/webhooks | Update Shop Webhook
*FulfilmentApi* | [**createPackages**](docs/Api/FulfilmentApi.md#createpackages) | **POST** /fulfillment/202309/packages | Create Packages
*FulfilmentApi* | [**getPackageDetail**](docs/Api/FulfilmentApi.md#getpackagedetail) | **GET** /fulfillment/202309/packages/{package_id} | Get Package Detail
*FulfilmentApi* | [**markPackageAsShipped**](docs/Api/FulfilmentApi.md#markpackageasshipped) | **POST** /fulfillment/202309/orders/{order_id}/packages | Mark Package As Shipped
*FulfilmentApi* | [**shipPackage**](docs/Api/FulfilmentApi.md#shippackage) | **POST** /fulfillment/202309/packages/{package_id}/ship | Ship Package
*FulfilmentApi* | [**updatePackageDeliveryStatus**](docs/Api/FulfilmentApi.md#updatepackagedeliverystatus) | **POST** /fulfillment/202309/packages/deliver | Update Package Delivery Status
*FulfilmentApi* | [**updateShippingInfo**](docs/Api/FulfilmentApi.md#updateshippinginfo) | **POST** /fulfillment/202309/orders/{order_id}/shipping_info/update | Update Shipping Info
*LogisticsApi* | [**getShippingProviders**](docs/Api/LogisticsApi.md#getshippingproviders) | **GET** /logistics/202309/delivery_options/{delivery_option_id}/shipping_providers | Get Shipping Providers
*LogisticsApi* | [**getWarehouseDeliveryOptions**](docs/Api/LogisticsApi.md#getwarehousedeliveryoptions) | **GET** /logistics/202309/warehouses/{warehouse_id}/delivery_options | Get Warehouse Delivery Options
*LogisticsApi* | [**getWarehouseList**](docs/Api/LogisticsApi.md#getwarehouselist) | **GET** /logistics/202309/warehouses | Get Warehouse List
*OrderApi* | [**getOrderDetail**](docs/Api/OrderApi.md#getorderdetail) | **GET** /order/202309/orders | Get Order Detail
*OrderApi* | [**getOrderList**](docs/Api/OrderApi.md#getorderlist) | **POST** /order/202309/orders/search | Get Order List
*OrderApi* | [**getPriceDetail**](docs/Api/OrderApi.md#getpricedetail) | **GET** /order/202407/orders/{order_id}/price_detail | Get Price Detail
*ProductApi* | [**activateProduct**](docs/Api/ProductApi.md#activateproduct) | **POST** /product/202309/products/activate | Activate Products
*ProductApi* | [**createBrand**](docs/Api/ProductApi.md#createbrand) | **POST** /product/202309/brands | Create Brands
*ProductApi* | [**createProduct**](docs/Api/ProductApi.md#createproduct) | **POST** /product/202309/products | Create Product
*ProductApi* | [**deactivateProducts**](docs/Api/ProductApi.md#deactivateproducts) | **POST** /product/202309/products/deactivate | Deactivate Products
*ProductApi* | [**deleteProducts**](docs/Api/ProductApi.md#deleteproducts) | **DELETE** /product/202309/products | Delete Products
*ProductApi* | [**editProduct**](docs/Api/ProductApi.md#editproduct) | **PUT** /product/202309/products/{product_id} | Edit Product
*ProductApi* | [**getAttributes**](docs/Api/ProductApi.md#getattributes) | **GET** /product/202309/categories/{category_id}/attributes | Get Attributes
*ProductApi* | [**getBrands**](docs/Api/ProductApi.md#getbrands) | **GET** /product/202309/brands | Get Brands
*ProductApi* | [**getCategories**](docs/Api/ProductApi.md#getcategories) | **GET** /product/202309/categories | Get Categories
*ProductApi* | [**getProduct**](docs/Api/ProductApi.md#getproduct) | **GET** /product/202309/products/{product_id} | Get Product
*ProductApi* | [**getProduct202309CategoriesCategoryIdRules**](docs/Api/ProductApi.md#getproduct202309categoriescategoryidrules) | **GET** /product/202309/categories/{category_id}/rules | Get Category Rules
*ProductApi* | [**inventorySearch**](docs/Api/ProductApi.md#inventorysearch) | **POST** /product/202309/inventory/search | Inventory Search
*ProductApi* | [**partialEditProduct**](docs/Api/ProductApi.md#partialeditproduct) | **POST** /product/202309/products/{product_id}/partial_edit | Partial Edit Product
*ProductApi* | [**recommendCategory**](docs/Api/ProductApi.md#recommendcategory) | **POST** /product/202309/categories/recommend | Recommend Category
*ProductApi* | [**searchProducts**](docs/Api/ProductApi.md#searchproducts) | **POST** /product/202312/products/search | Search Products
*ProductApi* | [**updateInventory**](docs/Api/ProductApi.md#updateinventory) | **POST** /product/202309/products/{product_id}/inventory/update | Update Inventory
*ProductApi* | [**updatePrice**](docs/Api/ProductApi.md#updateprice) | **POST** /product/202309/products/{product_id}/prices/update | Update Price
*ProductApi* | [**uploadProductFile**](docs/Api/ProductApi.md#uploadproductfile) | **POST** /product/202309/files/upload | Upload Product File
*ProductApi* | [**uploadProductImage**](docs/Api/ProductApi.md#uploadproductimage) | **POST** /product/202309/images/upload | Upload Product Image
*ReturnRefundApi* | [**getReturnRecords**](docs/Api/ReturnRefundApi.md#getreturnrecords) | **GET** /return_refund/202309/returns/{return_id}/records | Get Return Records
*ReturnRefundApi* | [**searchCancellations**](docs/Api/ReturnRefundApi.md#searchcancellations) | **POST** /return_refund/202309/cancellations/search | Search Cancellations
*ReturnRefundApi* | [**searchReturns**](docs/Api/ReturnRefundApi.md#searchreturns) | **POST** /return_refund/202309/returns/search | Search Returns

## Models

- [Address](docs/Model/Address.md)
- [Attribute](docs/Model/Attribute.md)
- [AttributeResponse](docs/Model/AttributeResponse.md)
- [AttributeResponseData](docs/Model/AttributeResponseData.md)
- [Brand](docs/Model/Brand.md)
- [BrandsResponse](docs/Model/BrandsResponse.md)
- [BrandsResponseData](docs/Model/BrandsResponseData.md)
- [CampaignInventory](docs/Model/CampaignInventory.md)
- [CancelLineItem](docs/Model/CancelLineItem.md)
- [Cancellation](docs/Model/Cancellation.md)
- [CategoriesResponse](docs/Model/CategoriesResponse.md)
- [CategoriesResponseData](docs/Model/CategoriesResponseData.md)
- [Category](docs/Model/Category.md)
- [CategoryRuleResponse](docs/Model/CategoryRuleResponse.md)
- [CategoryRuleResponseData](docs/Model/CategoryRuleResponseData.md)
- [CategoryRuleResponseDataCod](docs/Model/CategoryRuleResponseDataCod.md)
- [CategoryRuleResponseDataEpr](docs/Model/CategoryRuleResponseDataEpr.md)
- [CategoryRuleResponseDataProductCertificationsInner](docs/Model/CategoryRuleResponseDataProductCertificationsInner.md)
- [CategoryRuleResponseDataProductCertificationsInnerRequirementConditionsInner](docs/Model/CategoryRuleResponseDataProductCertificationsInnerRequirementConditionsInner.md)
- [CategoryRuleResponseDataSizeChart](docs/Model/CategoryRuleResponseDataSizeChart.md)
- [Certification](docs/Model/Certification.md)
- [CombinedSku](docs/Model/CombinedSku.md)
- [CreatePackagesRequest](docs/Model/CreatePackagesRequest.md)
- [CreatePackagesResponse](docs/Model/CreatePackagesResponse.md)
- [CreatePackagesResponseData](docs/Model/CreatePackagesResponseData.md)
- [CreateProductRequest](docs/Model/CreateProductRequest.md)
- [CreateProductResponse](docs/Model/CreateProductResponse.md)
- [CreateProductResponseData](docs/Model/CreateProductResponseData.md)
- [CreatorInventory](docs/Model/CreatorInventory.md)
- [DeliveryOption](docs/Model/DeliveryOption.md)
- [DeliveryPreferences](docs/Model/DeliveryPreferences.md)
- [Dimension](docs/Model/Dimension.md)
- [DiscountAmount](docs/Model/DiscountAmount.md)
- [DistrictInfo](docs/Model/DistrictInfo.md)
- [Error](docs/Model/Error.md)
- [ErrorDetail](docs/Model/ErrorDetail.md)
- [ExtraError](docs/Model/ExtraError.md)
- [FileUploadResponse](docs/Model/FileUploadResponse.md)
- [FileUploadResponseData](docs/Model/FileUploadResponseData.md)
- [GenericWebhook](docs/Model/GenericWebhook.md)
- [GetProductResponse](docs/Model/GetProductResponse.md)
- [IdResponse](docs/Model/IdResponse.md)
- [IdResponseData](docs/Model/IdResponseData.md)
- [IdentifierCode](docs/Model/IdentifierCode.md)
- [Image](docs/Model/Image.md)
- [ImageUploadResponse](docs/Model/ImageUploadResponse.md)
- [InShopInventory](docs/Model/InShopInventory.md)
- [Inventory](docs/Model/Inventory.md)
- [InventoryDistribution](docs/Model/InventoryDistribution.md)
- [InventorySearch](docs/Model/InventorySearch.md)
- [InventorySearchResponse](docs/Model/InventorySearchResponse.md)
- [InventorySku](docs/Model/InventorySku.md)
- [InventoryUpdate](docs/Model/InventoryUpdate.md)
- [InventoryUpdateResponse](docs/Model/InventoryUpdateResponse.md)
- [InventoryUpdateResponseData](docs/Model/InventoryUpdateResponseData.md)
- [InventoryUpdateSku](docs/Model/InventoryUpdateSku.md)
- [InventoryUpdateWarehouse](docs/Model/InventoryUpdateWarehouse.md)
- [ItemTax](docs/Model/ItemTax.md)
- [LineItem](docs/Model/LineItem.md)
- [Manufacturer](docs/Model/Manufacturer.md)
- [Order](docs/Model/Order.md)
- [OrderSearch](docs/Model/OrderSearch.md)
- [OrderSearchResponse](docs/Model/OrderSearchResponse.md)
- [OrderSearchResponseData](docs/Model/OrderSearchResponseData.md)
- [OrderStatusWebhook](docs/Model/OrderStatusWebhook.md)
- [OrderStatusWebhookData](docs/Model/OrderStatusWebhookData.md)
- [Package](docs/Model/Package.md)
- [PackageDeliveryStatus](docs/Model/PackageDeliveryStatus.md)
- [PackageDeliveryStatusRequest](docs/Model/PackageDeliveryStatusRequest.md)
- [PackageDeliveryStatusResponse](docs/Model/PackageDeliveryStatusResponse.md)
- [PackageDeliveryStatusResponseData](docs/Model/PackageDeliveryStatusResponseData.md)
- [PackageDeliveryStatusResponseDataErrorsInner](docs/Model/PackageDeliveryStatusResponseDataErrorsInner.md)
- [PackageDeliveryStatusResponseDataErrorsInnerDetail](docs/Model/PackageDeliveryStatusResponseDataErrorsInnerDetail.md)
- [PackageDetailResponse](docs/Model/PackageDetailResponse.md)
- [PackageDetailResponseData](docs/Model/PackageDetailResponseData.md)
- [PackageDetailResponseDataPickupSlot](docs/Model/PackageDetailResponseDataPickupSlot.md)
- [PackageDetailResponseDataWeight](docs/Model/PackageDetailResponseDataWeight.md)
- [PackageDetailsOrder](docs/Model/PackageDetailsOrder.md)
- [PackageDetailsSku](docs/Model/PackageDetailsSku.md)
- [PackageShippedRequest](docs/Model/PackageShippedRequest.md)
- [PackageShippedResponse](docs/Model/PackageShippedResponse.md)
- [PackageShippedResponseData](docs/Model/PackageShippedResponseData.md)
- [PackageShippedResponseDataWarning](docs/Model/PackageShippedResponseDataWarning.md)
- [Payment](docs/Model/Payment.md)
- [PickupSlot](docs/Model/PickupSlot.md)
- [PriceDetail](docs/Model/PriceDetail.md)
- [PriceDetailItem](docs/Model/PriceDetailItem.md)
- [PriceDetailResponse](docs/Model/PriceDetailResponse.md)
- [Product](docs/Model/Product.md)
- [ProductIDsRequest](docs/Model/ProductIDsRequest.md)
- [ProductIDsResponse](docs/Model/ProductIDsResponse.md)
- [ProductIDsResponseData](docs/Model/ProductIDsResponseData.md)
- [ProductIDsResponseDataErrorsInner](docs/Model/ProductIDsResponseDataErrorsInner.md)
- [ProductIDsResponseDataErrorsInnerDetail](docs/Model/ProductIDsResponseDataErrorsInnerDetail.md)
- [ProductIDsResponseDataErrorsInnerDetailExtraErrorsInner](docs/Model/ProductIDsResponseDataErrorsInnerDetailExtraErrorsInner.md)
- [ProductInventory](docs/Model/ProductInventory.md)
- [ProductPrice](docs/Model/ProductPrice.md)
- [ProductPriceRequest](docs/Model/ProductPriceRequest.md)
- [ProductSearch](docs/Model/ProductSearch.md)
- [ProductSearchResponse](docs/Model/ProductSearchResponse.md)
- [ProductSearchResponseData](docs/Model/ProductSearchResponseData.md)
- [ProductSku](docs/Model/ProductSku.md)
- [ProductSummary](docs/Model/ProductSummary.md)
- [RecommendCategoryRequest](docs/Model/RecommendCategoryRequest.md)
- [RecommendCategoryResponse](docs/Model/RecommendCategoryResponse.md)
- [RecommendCategoryResponseData](docs/Model/RecommendCategoryResponseData.md)
- [RefundAmount](docs/Model/RefundAmount.md)
- [RequirementCondition](docs/Model/RequirementCondition.md)
- [Response](docs/Model/Response.md)
- [ReturnLineItem](docs/Model/ReturnLineItem.md)
- [ReturnOrder](docs/Model/ReturnOrder.md)
- [ReturnRecord](docs/Model/ReturnRecord.md)
- [ReturnRecordsResponse](docs/Model/ReturnRecordsResponse.md)
- [ReturnRecordsResponseData](docs/Model/ReturnRecordsResponseData.md)
- [ReturnStatusWebhook](docs/Model/ReturnStatusWebhook.md)
- [ReturnStatusWebhookData](docs/Model/ReturnStatusWebhookData.md)
- [SalesAttribute](docs/Model/SalesAttribute.md)
- [SearchCancellationsRequest](docs/Model/SearchCancellationsRequest.md)
- [SearchCancellationsResponse](docs/Model/SearchCancellationsResponse.md)
- [SearchCancellationsResponseData](docs/Model/SearchCancellationsResponseData.md)
- [SearchReturnsRequest](docs/Model/SearchReturnsRequest.md)
- [SearchReturnsResponse](docs/Model/SearchReturnsResponse.md)
- [SearchReturnsResponseData](docs/Model/SearchReturnsResponseData.md)
- [SearchReturnsResponseDataReturnOrdersInner](docs/Model/SearchReturnsResponseDataReturnOrdersInner.md)
- [SearchReturnsResponseDataReturnOrdersInnerDiscountAmountInner](docs/Model/SearchReturnsResponseDataReturnOrdersInnerDiscountAmountInner.md)
- [SearchReturnsResponseDataReturnOrdersInnerRefundAmount](docs/Model/SearchReturnsResponseDataReturnOrdersInnerRefundAmount.md)
- [SearchReturnsResponseDataReturnOrdersInnerReturnLineItemsInner](docs/Model/SearchReturnsResponseDataReturnOrdersInnerReturnLineItemsInner.md)
- [SearchReturnsResponseDataReturnOrdersInnerReturnLineItemsInnerProductImage](docs/Model/SearchReturnsResponseDataReturnOrdersInnerReturnLineItemsInnerProductImage.md)
- [SearchReturnsResponseDataReturnOrdersInnerSellerNextActionResponseInner](docs/Model/SearchReturnsResponseDataReturnOrdersInnerSellerNextActionResponseInner.md)
- [SearchReturnsResponseDataReturnOrdersInnerShippingFeeAmountInner](docs/Model/SearchReturnsResponseDataReturnOrdersInnerShippingFeeAmountInner.md)
- [SelfShipment](docs/Model/SelfShipment.md)
- [SellerNextActionResponse](docs/Model/SellerNextActionResponse.md)
- [ShipPackageRequest](docs/Model/ShipPackageRequest.md)
- [ShippingFeeAmount](docs/Model/ShippingFeeAmount.md)
- [ShippingInfoRequest](docs/Model/ShippingInfoRequest.md)
- [ShippingProvdersResponse](docs/Model/ShippingProvdersResponse.md)
- [ShippingProvdersResponseData](docs/Model/ShippingProvdersResponseData.md)
- [ShippingProvider](docs/Model/ShippingProvider.md)
- [ShippingServiceInfo](docs/Model/ShippingServiceInfo.md)
- [Shop](docs/Model/Shop.md)
- [ShopsResponse](docs/Model/ShopsResponse.md)
- [ShopsResponseData](docs/Model/ShopsResponseData.md)
- [SizeChart](docs/Model/SizeChart.md)
- [SkuPrice](docs/Model/SkuPrice.md)
- [Template](docs/Model/Template.md)
- [Value](docs/Model/Value.md)
- [Video](docs/Model/Video.md)
- [Warehouse](docs/Model/Warehouse.md)
- [WarehouseAddress](docs/Model/WarehouseAddress.md)
- [WarehouseDeliveryOptionResponse](docs/Model/WarehouseDeliveryOptionResponse.md)
- [WarehouseDeliveryOptionResponseData](docs/Model/WarehouseDeliveryOptionResponseData.md)
- [WarehouseInventory](docs/Model/WarehouseInventory.md)
- [WarehouseListResponse](docs/Model/WarehouseListResponse.md)
- [WarehouseListResponseData](docs/Model/WarehouseListResponseData.md)
- [Warning](docs/Model/Warning.md)
- [Webhook](docs/Model/Webhook.md)
- [WebhooksResponse](docs/Model/WebhooksResponse.md)
- [WebhooksResponseData](docs/Model/WebhooksResponseData.md)
- [Weight](docs/Model/Weight.md)
- [WeightLimit](docs/Model/WeightLimit.md)

## Authorization
Endpoints do not require authorization.

## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author



## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `1.0`
    - Package version: `1.0`
    - Generator version: `7.5.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
