<?php
/**
 * ObjectSerializer
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Temu Open APIs
 *
 * Comprehensive API collection for Temu marketplace operations including product management, order processing, inventory management, pricing, and fulfillment services.  All endpoints use POST method with operation type specified in request body. Authentication uses MD5 signature with app_key, app_secret, access_token, and timestamp.
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.1.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Temu;

use GuzzleHttp\Psr7\Utils;
use Temu\Model\ModelInterface;

/**
 * ObjectSerializer Class Doc Comment
 *
 * Handles JSON serialization and deserialization for Temu API requests and responses.
 *
 * This utility class provides comprehensive type-safe serialization between PHP objects
 * and JSON format, with support for:
 * - Complex nested objects and arrays
 * - DateTime formatting and parsing
 * - File uploads (SplFileObject handling)
 * - Enum validation
 * - Query string parameter formatting
 * - OpenAPI type mapping
 *
 * All API requests and responses flow through this serializer, ensuring consistent
 * data transformation and validation across the SDK.
 *
 * @category Class
 * @package  Temu
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 *
 * @example Basic Serialization
 * ```php
 * $request = new GoodsListRequest(['page_num' => 1, 'page_size' => 20]);
 * $json = ObjectSerializer::sanitizeForSerialization($request);
 * // Result: {"page_num": 1, "page_size": 20}
 * ```
 *
 * @example DateTime Handling
 * ```php
 * $data = ['created_at' => new DateTime('2025-01-01 12:00:00')];
 * $serialized = ObjectSerializer::sanitizeForSerialization($data);
 * // Result: {"created_at": "2025-01-01T12:00:00+00:00"}
 * ```
 *
 * @example Deserialization
 * ```php
 * $json = '{"success": true, "result": {"goods_list": []}}';
 * $response = ObjectSerializer::deserialize($json, 'Temu\Model\GoodsListResponse');
 * // Returns: GoodsListResponse object
 * ```
 */
class ObjectSerializer
{
    /**
     * Default DateTime format for serialization
     *
     * Uses ISO 8601 format (\DateTime::ATOM) by default, which produces timestamps like:
     * 2025-01-20T10:30:00+00:00
     *
     * Can be customized using setDateTimeFormat() if API requires different format.
     *
     * @var string
     */
    private static $dateTimeFormat = \DateTime::ATOM;

    /**
     * Change the default DateTime format for serialization
     *
     * Allows customization of the DateTime format used when serializing DateTime objects
     * to JSON. The format should be a valid PHP date format string.
     *
     * Common formats:
     * - \DateTime::ATOM (default): '2025-01-20T10:30:00+00:00' (ISO 8601)
     * - 'Y-m-d H:i:s': '2025-01-20 10:30:00'
     * - 'Y-m-d': '2025-01-20' (date only)
     * - 'U': Unix timestamp
     *
     * @param string $format The new date format to use (PHP date format string)
     *
     * @return void
     *
     * @see https://www.php.net/manual/en/datetime.format.php
     *
     * @example
     * ```php
     * // Change to MySQL datetime format
     * ObjectSerializer::setDateTimeFormat('Y-m-d H:i:s');
     *
     * // Change to Unix timestamp
     * ObjectSerializer::setDateTimeFormat('U');
     * ```
     */
    public static function setDateTimeFormat($format)
    {
        self::$dateTimeFormat = $format;
    }

    /**
     * Serialize data for API transmission
     *
     * Recursively converts PHP data structures into a format suitable for JSON encoding
     * and API transmission. Handles complex types including:
     * - Scalar values (strings, integers, booleans, floats)
     * - DateTime objects (formatted according to $format or default)
     * - Arrays (recursively serialized)
     * - Model objects implementing ModelInterface (with property mapping and validation)
     * - Nested objects and collections
     *
     * For Model objects, this method:
     * - Validates enum values against allowed values
     * - Maps property names using the model's attribute map
     * - Respects nullable properties and null values
     * - Applies type-specific formatting (e.g., date vs datetime)
     *
     * @param mixed $data The data to serialize (scalar, array, object, or null)
     * @param string $type The OpenAPI type of the data (optional, for type-specific handling)
     * @param string $format The format of the OpenAPI type (optional, e.g., 'date' for date-only)
     *
     * @return scalar|object|array|null Serialized form of $data ready for JSON encoding
     *
     * @throws \InvalidArgumentException If enum value is not in the allowed values list
     *
     * @example Serialize a request object
     * ```php
     * $request = new GoodsListRequest(['page_num' => 1, 'page_size' => 20]);
     * $data = ObjectSerializer::sanitizeForSerialization($request);
     * $json = json_encode($data);
     * ```
     *
     * @example Serialize with DateTime
     * ```php
     * $data = [
     *     'start_date' => new DateTime('2025-01-01'),
     *     'products' => [
     *         ['id' => 1, 'name' => 'Product A'],
     *         ['id' => 2, 'name' => 'Product B']
     *     ]
     * ];
     * $serialized = ObjectSerializer::sanitizeForSerialization($data);
     * ```
     */
    public static function sanitizeForSerialization($data, $type = null, $format = null)
    {
        if (is_scalar($data) || null === $data) {
            return $data;
        }

        if ($data instanceof \DateTime) {
            return ($format === 'date') ? $data->format('Y-m-d') : $data->format(self::$dateTimeFormat);
        }

        if (is_array($data)) {
            foreach ($data as $property => $value) {
                $data[$property] = self::sanitizeForSerialization($value);
            }
            return $data;
        }

        if (is_object($data)) {
            $values = [];
            if ($data instanceof ModelInterface) {
                $formats = $data::openAPIFormats();
                foreach ($data::openAPITypes() as $property => $openAPIType) {
                    $getter = $data::getters()[$property];
                    $value = $data->$getter();
                    if ($value !== null && !in_array($openAPIType, ['\DateTime', '\SplFileObject', 'array', 'bool', 'boolean', 'byte', 'float', 'int', 'integer', 'mixed', 'number', 'object', 'string', 'void'], true)) {
                        $callable = [$openAPIType, 'getAllowableEnumValues'];
                        if (is_callable($callable)) {
                            /** array $callable */
                            $allowedEnumTypes = $callable();
                            if (!in_array($value, $allowedEnumTypes, true)) {
                                $imploded = implode("', '", $allowedEnumTypes);
                                throw new \InvalidArgumentException("Invalid value for enum '$openAPIType', must be one of: '$imploded'");
                            }
                        }
                    }
                    if (($data::isNullable($property) && $data->isNullableSetToNull($property)) || $value !== null) {
                        $values[$data::attributeMap()[$property]] = self::sanitizeForSerialization($value, $openAPIType, $formats[$property]);
                    }
                }
            } else {
                foreach ($data as $property => $value) {
                    $values[$property] = self::sanitizeForSerialization($value);
                }
            }
            return (object)$values;
        }

        return (string)$data;

    }

    /**
     * Sanitize filename by removing path.
     * e.g. ../../sun.gif becomes sun.gif
     *
     * @param string $filename filename to be sanitized
     *
     * @return string the sanitized filename
     */
    public static function sanitizeFilename($filename)
    {
        if (preg_match("/.*[\/\\\\](.*)$/", $filename, $match)) {
            return $match[1];
        }
        return $filename;

    }

    /**
     * Shorter timestamp microseconds to 6 digits length.
     *
     * @param string $timestamp Original timestamp
     *
     * @return string the shorten timestamp
     */
    public static function sanitizeTimestamp($timestamp)
    {
        if (!is_string($timestamp)) return $timestamp;

        return preg_replace('/(:\d{2}.\d{6})\d*/', '$1', $timestamp);
    }

    /**
     * Take value and turn it into a string suitable for inclusion in
     * the path, by url-encoding.
     *
     * @param string $value a string which will be part of the path
     *
     * @return string the serialized object
     */
    public static function toPathValue($value)
    {
        return rawurlencode(self::toString($value));
    }

    /**
     * Checks if a value is empty, based on its OpenAPI type.
     *
     * @param mixed $value
     * @param string $openApiType
     *
     * @return bool true if $value is empty
     */
    private static function isEmptyValue($value, string $openApiType): bool
    {
        # If empty() returns false, it is not empty regardless of its type.
        if (!empty($value)) {
            return false;
        }

        # Null is always empty, as we cannot send a real "null" value in a query parameter.
        if ($value === null) {
            return true;
        }

        switch ($openApiType) {
            # For numeric values, false and '' are considered empty.
            # This comparison is safe for floating point values, since the previous call to empty() will
            # filter out values that don't match 0.
            case 'int':
            case 'integer':
                return $value !== 0;

            case 'number':
            case 'float':
                return $value !== 0 && $value !== 0.0;

            # For boolean values, '' is considered empty
            case 'bool':
            case 'boolean':
                return !in_array($value, [false, 0], true);

            # For all the other types, any value at this point can be considered empty.
            default:
                return true;
        }
    }

    /**
     * Take query parameter properties and turn it into an array suitable for
     * native http_build_query or GuzzleHttp\Psr7\Query::build.
     *
     * @param mixed $value Parameter value
     * @param string $paramName Parameter name
     * @param string $openApiType OpenAPIType eg. array or object
     * @param string $style Parameter serialization style
     * @param bool $explode Parameter explode option
     * @param bool $required Whether query param is required or not
     *
     * @return array
     */
    public static function toQueryValue(
        $value,
        string $paramName,
        string $openApiType = 'string',
        string $style = 'form',
        bool $explode = true,
        bool $required = true
    ): array
    {

        # Check if we should omit this parameter from the query. This should only happen when:
        #  - Parameter is NOT required; AND
        #  - its value is set to a value that is equivalent to "empty", depending on its OpenAPI type. For
        #    example, 0 as "int" or "boolean" is NOT an empty value.
        if (self::isEmptyValue($value, $openApiType)) {
            if ($required) {
                return ["{$paramName}" => ''];
            }
            return [];
        }

        # Handle DateTime objects in query
        if ($openApiType === "\\DateTime" && $value instanceof \DateTime) {
            return ["{$paramName}" => $value->format(self::$dateTimeFormat)];
        }

        $query = [];
        $value = (in_array($openApiType, ['object', 'array'], true)) ? (array)$value : $value;

        // since \GuzzleHttp\Psr7\Query::build fails with nested arrays
        // need to flatten array first
        $flattenArray = function ($arr, $name, &$result = []) use (&$flattenArray, $style, $explode) {
            if (!is_array($arr)) return $arr;

            foreach ($arr as $k => $v) {
                $prop = ($style === 'deepObject') ? $prop = "{$name}[{$k}]" : $k;

                if (is_array($v)) {
                    $flattenArray($v, $prop, $result);
                } else {
                    if ($style !== 'deepObject' && !$explode) {
                        // push key itself
                        $result[] = $prop;
                    }
                    $result[$prop] = $v;
                }
            }
            return $result;
        };

        $value = $flattenArray($value, $paramName);

        if ($openApiType === 'object' && ($style === 'deepObject' || $explode)) {
            return $value;
        }

        if ('boolean' === $openApiType && is_bool($value)) {
            $value = self::convertBoolToQueryStringFormat($value);
        }

        // handle style in serializeCollection
        $query[$paramName] = ($explode) ? $value : self::serializeCollection((array)$value, $style);

        return $query;
    }

    /**
     * Convert boolean value to format for query string.
     *
     * @param bool $value Boolean value
     *
     * @return int|string Boolean value in format
     */
    public static function convertBoolToQueryStringFormat(bool $value)
    {
        if (Configuration::BOOLEAN_FORMAT_STRING == Configuration::getDefaultConfiguration()->getBooleanFormatForQueryString()) {
            return $value ? 'true' : 'false';
        }

        return (int)$value;
    }

    /**
     * Take value and turn it into a string suitable for inclusion in
     * the header. If it's a string, pass through unchanged
     * If it's a datetime object, format it in ISO8601
     *
     * @param string $value a string which will be part of the header
     *
     * @return string the header string
     */
    public static function toHeaderValue($value)
    {
        $callable = [$value, 'toHeaderValue'];
        if (is_callable($callable)) {
            return $callable();
        }

        return self::toString($value);
    }

    /**
     * Take value and turn it into a string suitable for inclusion in
     * the http body (form parameter). If it's a string, pass through unchanged
     * If it's a datetime object, format it in ISO8601
     *
     * @param string|\SplFileObject $value the value of the form parameter
     *
     * @return string the form string
     */
    public static function toFormValue($value)
    {
        if ($value instanceof \SplFileObject) {
            return $value->getRealPath();
        }
        return self::toString($value);

    }

    /**
     * Take value and turn it into a string suitable for inclusion in
     * the parameter. If it's a string, pass through unchanged
     * If it's a datetime object, format it in ISO8601
     * If it's a boolean, convert it to "true" or "false".
     *
     * @param string|bool|\DateTime $value the value of the parameter
     *
     * @return string the header string
     */
    public static function toString($value)
    {
        if ($value instanceof \DateTime) { // datetime in ISO8601 format
            return $value->format(self::$dateTimeFormat);
        }

        if (is_bool($value)) {
            return $value ? 'true' : 'false';
        }
        return (string)$value;

    }

    /**
     * Serialize an array to a string.
     *
     * @param array $collection collection to serialize to a string
     * @param string $style the format use for serialization (csv,
     * ssv, tsv, pipes, multi)
     * @param bool $allowCollectionFormatMulti allow collection format to be a multidimensional array
     *
     * @return string
     */
    public static function serializeCollection(array $collection, $style, $allowCollectionFormatMulti = false)
    {
        if ($allowCollectionFormatMulti && ('multi' === $style)) {
            // http_build_query() almost does the job for us. We just
            // need to fix the result of multidimensional arrays.
            return preg_replace('/%5B[0-9]+%5D=/', '=', http_build_query($collection, '', '&'));
        }
        switch ($style) {
            case 'pipeDelimited':
            case 'pipes':
                return implode('|', $collection);

            case 'tsv':
                return implode("\t", $collection);

            case 'spaceDelimited':
            case 'ssv':
                return implode(' ', $collection);

            case 'simple':
            case 'csv':
                // Deliberate fall through. CSV is default format.
            default:
                return implode(',', $collection);
        }
    }

    /**
     * Deserialize JSON data into a typed PHP object
     *
     * Converts JSON strings or data structures into strongly-typed PHP objects based on
     * the OpenAPI specification. This method handles:
     * - Primitive types (int, string, bool, float)
     * - Arrays and collections (ClassName[])
     * - Associative arrays (array<string,Type>, map[string,Type])
     * - DateTime objects (from ISO 8601 strings)
     * - File downloads (SplFileObject)
     * - Complex model objects with nested structures
     * - Enum validation
     * - Polymorphic types using discriminators
     *
     * The deserialization process:
     * 1. Parses JSON string if needed
     * 2. Checks for polymorphic discriminators
     * 3. Creates instance of target class
     * 4. Maps JSON properties to object properties using attribute map
     * 5. Recursively deserializes nested objects
     * 6. Validates enum values
     * 7. Handles nullable properties
     *
     * @param mixed $data The data to deserialize (JSON string, array, or object)
     * @param string $class Fully qualified class name (e.g., 'Temu\Model\GoodsListResponse')
     *                                 Use 'ClassName[]' for arrays, 'array<string,Type>' for maps
     * @param string[] $httpHeaders HTTP response headers (used for file downloads)
     * @param string $discriminator Discriminator field name for polymorphism (optional)
     *
     * @return object|array|null Instance of $class, array of instances, or null
     *
     * @throws \InvalidArgumentException If data cannot be deserialized to target type
     * @throws \InvalidArgumentException If enum value is invalid
     *
     * @example Deserialize response
     * ```php
     * $json = '{"success":true,"result":{"goods_list":[...]}}';
     * $response = ObjectSerializer::deserialize(
     *     $json,
     *     'Temu\Model\GoodsListResponse'
     * );
     * echo $response->getSuccess(); // true
     * ```
     *
     * @example Deserialize array of objects
     * ```php
     * $json = '[{"id":1,"name":"Product A"},{"id":2,"name":"Product B"}]';
     * $products = ObjectSerializer::deserialize($json, 'Temu\Model\Product[]');
     * // Returns: array of Product objects
     * ```
     *
     * @example Deserialize with DateTime handling
     * ```php
     * $json = '{"created_at":"2025-01-20T10:30:00+00:00"}';
     * $data = ObjectSerializer::deserialize($json, 'Temu\Model\OrderDetail');
     * $datetime = $data->getCreatedAt(); // DateTime object
     * ```
     */
    public static function deserialize($data, $class, $httpHeaders = null)
    {
        if (null === $data) {
            return null;
        }

        if (strcasecmp(substr($class, -2), '[]') === 0) {
            $data = is_string($data) ? json_decode($data) : $data;

            if (!is_array($data)) {
                throw new \InvalidArgumentException("Invalid array '$class'");
            }

            $subClass = substr($class, 0, -2);
            $values = [];
            foreach ($data as $key => $value) {
                $values[] = self::deserialize($value, $subClass, null);
            }
            return $values;
        }

        if (preg_match('/^(array<|map\[)/', $class)) { // for associative array e.g. array<string,int>
            $data = is_string($data) ? json_decode($data) : $data;
            settype($data, 'array');
            $inner = substr($class, 4, -1);
            $deserialized = [];
            if (strrpos($inner, ",") !== false) {
                $subClass_array = explode(',', $inner, 2);
                $subClass = $subClass_array[1];
                foreach ($data as $key => $value) {
                    $deserialized[$key] = self::deserialize($value, $subClass, null);
                }
            }
            return $deserialized;
        }

        if ($class === 'object') {
            $data = (array)$data;
            return $data;
        }

        if ($class === 'mixed') {
            settype($data, gettype($data));
            return $data;
        }

        if ($class === '\DateTime') {
            // Some APIs return an invalid, empty string as a
            // date-time property. DateTime::__construct() will return
            // the current time for empty input which is probably not
            // what is meant. The invalid empty string is probably to
            // be interpreted as a missing field/value. Let's handle
            // this graceful.
            if (!empty($data)) {
                try {
                    return new \DateTime($data);
                } catch (\Exception $exception) {
                    // Some APIs return a date-time with too high nanosecond
                    // precision for php's DateTime to handle.
                    // With provided regexp 6 digits of microseconds saved
                    return new \DateTime(self::sanitizeTimestamp($data));
                }
            } else {
                return null;
            }
        }

        if ($class === '\SplFileObject') {
            $data = Utils::streamFor($data);

            /** @var \Psr\Http\Message\StreamInterface $data */

            // determine file name
            if (
                is_array($httpHeaders)
                && array_key_exists('Content-Disposition', $httpHeaders)
                && preg_match('/inline; filename=[\'"]?([^\'"\s]+)[\'"]?$/i', $httpHeaders['Content-Disposition'], $match)
            ) {
                $filename = Configuration::getDefaultConfiguration()->getTempFolderPath() . DIRECTORY_SEPARATOR . self::sanitizeFilename($match[1]);
            } else {
                $filename = tempnam(Configuration::getDefaultConfiguration()->getTempFolderPath(), '');
            }

            $file = fopen($filename, 'wb');
            while ($chunk = $data->read(200)) {
                fwrite($file, $chunk);
            }
            fclose($file);

            return new \SplFileObject($filename, 'r');
        }

        /** @psalm-suppress ParadoxicalCondition */
        if (in_array($class, ['\DateTime', '\SplFileObject', 'array', 'bool', 'boolean', 'byte', 'float', 'int', 'integer', 'mixed', 'number', 'object', 'string', 'void'], true)) {
            settype($data, $class);
            return $data;
        }


        if (method_exists($class, 'getAllowableEnumValues')) {
            if (!in_array($data, $class::getAllowableEnumValues(), true)) {
                $imploded = implode("', '", $class::getAllowableEnumValues());
                throw new \InvalidArgumentException("Invalid value for enum '$class', must be one of: '$imploded'");
            }
            return $data;
        }
        $data = is_string($data) ? json_decode($data) : $data;

        if (is_array($data)) {
            $data = (object)$data;
        }

        // If a discriminator is defined and points to a valid subclass, use it.
        $discriminator = $class::DISCRIMINATOR;
        if (!empty($discriminator) && isset($data->{$discriminator}) && is_string($data->{$discriminator})) {
            $subclass = '\Temu\Model\\' . $data->{$discriminator};
            if (is_subclass_of($subclass, $class)) {
                $class = $subclass;
            }
        }

        /** @var ModelInterface $instance */
        $instance = new $class();
        foreach ($instance::openAPITypes() as $property => $type) {
            $propertySetter = $instance::setters()[$property];

            if (!isset($propertySetter)) {
                continue;
            }

            if (!isset($data->{$instance::attributeMap()[$property]})) {
                if ($instance::isNullable($property)) {
                    $instance->$propertySetter(null);
                }

                continue;
            }

            if (isset($data->{$instance::attributeMap()[$property]})) {
                $propertyValue = $data->{$instance::attributeMap()[$property]};
                $instance->$propertySetter(self::deserialize($propertyValue, $type, null));
            }
        }
        return $instance;

    }

    /**
     * Native `http_build_query` wrapper.
     * @see https://www.php.net/manual/en/function.http-build-query
     *
     * @param array|object $data May be an array or object containing properties.
     * @param string $numeric_prefix If numeric indices are used in the base array and this parameter is provided, it will be prepended to the numeric index for elements in the base array only.
     * @param string|null $arg_separator arg_separator.output is used to separate arguments but may be overridden by specifying this parameter.
     * @param int $encoding_type Encoding type. By default, PHP_QUERY_RFC1738.
     *
     * @return string
     */
    public static function buildQuery(
        $data,
        string $numeric_prefix = '',
        ?string $arg_separator = null,
        int $encoding_type = \PHP_QUERY_RFC3986
    ): string
    {
        return \GuzzleHttp\Psr7\Query::build($data, $encoding_type);
    }
}
