<?php
/**
 * UploadImageWithAutoTransformerRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

/**
 * UploadImageWithAutoTransformerRequest Class - Request for UploadImageWithAutoTransformer API
 *
 * @category Class
 * @package  Temu
 */
class UploadImageWithAutoTransformerRequest extends BaseRequest
{
    protected string $responseClass = UploadImageWithAutoTransformerResponse::class;

    protected static $openAPITypes = [
        'file_url' => 'string',
        'format_conversion_type' => 'int',
        'scaling_type' => 'int',
        'compression_type' => 'int'
    ];

    protected static $attributeMap = [
        'file_url' => 'fileUrl',
        'format_conversion_type' => 'formatConversionType',
        'scaling_type' => 'scalingType',
        'compression_type' => 'compressionType'
    ];

    public function __construct(
        string $fileUrl,
        int $formatConversionType = 1,
        int $scalingType = 1,
        int $compressionType = 0
    ) {
        parent::__construct();
        $this->setType('bg.local.goods.image.upload');
        $this->setFileUrl($fileUrl);
        $this->setFormatConversionType($formatConversionType);
        $this->setScalingType($scalingType);
        $this->setCompressionType($compressionType);
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }

    public function getFileUrl(): string
    {
        return $this->container['file_url'];
    }

    public function setFileUrl(string $fileUrl): self
    {
        $this->container['file_url'] = $fileUrl;
        return $this;
    }

    public function getFormatConversionType(): int
    {
        return $this->container['format_conversion_type'];
    }

    public function setFormatConversionType(int $formatConversionType): self
    {
        $this->container['format_conversion_type'] = $formatConversionType;
        return $this;
    }

    public function getScalingType(): int
    {
        return $this->container['scaling_type'];
    }

    public function setScalingType(int $scalingType): self
    {
        $this->container['scaling_type'] = $scalingType;
        return $this;
    }

    public function getCompressionType(): int
    {
        return $this->container['compression_type'];
    }

    public function setCompressionType(int $compressionType): self
    {
        $this->container['compression_type'] = $compressionType;
        return $this;
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes + parent::openAPITypes();
    }

    public static function attributeMap(): array
    {
        return self::$attributeMap + parent::attributeMap();
    }
}
