<?php
/**
 * UpdateShipmentRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

/**
 * UpdateShipmentRequest Class - Request for UpdateShipment API
 *
 * @category Class
 * @package  Temu
 */
class UpdateShipmentRequest extends BaseRequest
{
    protected string $responseClass = UpdateShipmentResponse::class;

    protected static $openAPITypes = [
        'retry_send_package_request_list' => 'array'
    ];

    protected static $attributeMap = [
        'retry_send_package_request_list' => 'retrySendPackageRequestList'
    ];

    public function __construct(array $retrySendPackageRequestList)
    {
        parent::__construct();
        $this->setType('bg.logistics.shipment.update');
        $this->setRetrySendPackageRequestList($retrySendPackageRequestList);
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }

    public function getRetrySendPackageRequestList(): array
    {
        return $this->container['retry_send_package_request_list'];
    }

    public function setRetrySendPackageRequestList(array $retrySendPackageRequestList): self
    {
        $this->container['retry_send_package_request_list'] = $retrySendPackageRequestList;
        return $this;
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes + parent::openAPITypes();
    }

    public static function attributeMap(): array
    {
        return self::$attributeMap + parent::attributeMap();
    }
}
