<?php
/**
 * UpdateOrderShipmentInfoRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;

/**
 * UpdateOrderShipmentInfoRequest Class - Request model for updateOrderShipmentInfo API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class UpdateOrderShipmentInfoRequest extends BaseRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'UpdateOrderShipmentInfoRequest';

    protected static array $openAPITypes = [
        'type' => 'string',
        'packageSn' => 'string',
        'shipCompanyId' => 'string',
        'trackingNumber' => 'string'
    ];

    protected string $responseClass = UpdateOrderShipmentInfoResponse::class;

    public function __construct(string $packageSn, string $shipCompanyId, string $trackingNumber)
    {
        parent::__construct();
        $this->setType('bg.logistics.shipment.get');
        $this->setPackageSn($packageSn);
        $this->setShipCompanyId($shipCompanyId);
        $this->setTrackingNumber($trackingNumber);
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    public function getPackageSn(): ?string
    {
        return $this->container['packageSn'] ?? null;
    }

    public function setPackageSn(string $packageSn): self
    {
        $this->container['packageSn'] = $packageSn;
        return $this;
    }

    public function getShipCompanyId(): ?string
    {
        return $this->container['shipCompanyId'] ?? null;
    }

    public function setShipCompanyId(string $shipCompanyId): self
    {
        $this->container['shipCompanyId'] = $shipCompanyId;
        return $this;
    }

    public function getTrackingNumber(): ?string
    {
        return $this->container['trackingNumber'] ?? null;
    }

    public function setTrackingNumber(string $trackingNumber): self
    {
        $this->container['trackingNumber'] = $trackingNumber;
        return $this;
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }
}
