<?php
/**
 * UpdateGoodsStockResult
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;
use Temu\ObjectSerializer;

/**
 * UpdateGoodsStockResult Class Doc Comment
 *
 * Represents the result data for updateGoodsStock API response
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class UpdateGoodsStockResult implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static string $openAPIModelName = 'UpdateGoodsStockResult';

    protected static array $openAPITypes = [
        'errorCode' => 'string',
        'stockEditStatus' => 'bool',
        'skuId' => 'int',
        'goodsId' => 'int',
        'errorMsg' => 'string',
        'skuStockEditStatusInfoList' => '\Temu\Model\SkuStockEditStatusInfo[]'
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @var string[]
     */
    protected static array $openAPIFormats = [
        'errorCode' => null,
        'stockEditStatus' => null,
        'skuId' => 'int64',
        'goodsId' => 'int64',
        'errorMsg' => null,
        'skuStockEditStatusInfoList' => null
    ];

    /**
     * Array of nullable properties. Used for (de)serialization
     *
     * @var boolean[]
     */
    protected static array $openAPINullables = [
        'errorCode' => true,
        'stockEditStatus' => false,
        'skuId' => true,
        'goodsId' => false,
        'errorMsg' => true,
        'skuStockEditStatusInfoList' => false
    ];

    /**
     * If a nullable field gets set to null, insert it here
     *
     * @var boolean[]
     */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats(): array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->openAPINullablesSetToNull, true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'errorCode' => 'errorCode',
        'stockEditStatus' => 'stockEditStatus',
        'skuId' => 'skuId',
        'goodsId' => 'goodsId',
        'errorMsg' => 'errorMsg',
        'skuStockEditStatusInfoList' => 'skuStockEditStatusInfoList'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static array $setters = [
        'errorCode' => 'setErrorCode',
        'stockEditStatus' => 'setStockEditStatus',
        'skuId' => 'setSkuId',
        'goodsId' => 'setGoodsId',
        'errorMsg' => 'setErrorMsg',
        'skuStockEditStatusInfoList' => 'setSkuStockEditStatusInfoList'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static array $getters = [
        'errorCode' => 'getErrorCode',
        'stockEditStatus' => 'getStockEditStatus',
        'skuId' => 'getSkuId',
        'goodsId' => 'getGoodsId',
        'errorMsg' => 'getErrorMsg',
        'skuStockEditStatusInfoList' => 'getSkuStockEditStatusInfoList'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap(): array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters(): array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters(): array
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName(): string
    {
        return self::$openAPIModelName;
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor
     *
     * @param array|null $data Associated array of property values
     */
    public function __construct(?array $data = null)
    {
        $this->container['errorCode'] = $data['errorCode'] ?? null;
        $this->container['stockEditStatus'] = $data['stockEditStatus'] ?? null;
        $this->container['skuId'] = $data['skuId'] ?? null;
        $this->container['goodsId'] = $data['goodsId'] ?? null;
        $this->container['errorMsg'] = $data['errorMsg'] ?? null;
        $this->container['skuStockEditStatusInfoList'] = $data['skuStockEditStatusInfoList'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties(): array
    {
        return [];
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid(): bool
    {
        return count($this->listInvalidProperties()) === 0;
    }

    /**
     * Gets errorCode
     *
     * @return string|null
     */
    public function getErrorCode(): ?string
    {
        return $this->container['errorCode'] ?? null;
    }

    /**
     * Sets errorCode
     *
     * @param string|null $errorCode Error code from API
     *
     * @return self
     */
    public function setErrorCode(?string $errorCode): self
    {
        $this->container['errorCode'] = $errorCode;
        return $this;
    }

    /**
     * Gets stockEditStatus
     *
     * @return bool|null
     */
    public function getStockEditStatus(): ?bool
    {
        return $this->container['stockEditStatus'] ?? null;
    }

    /**
     * Sets stockEditStatus
     *
     * @param bool|null $stockEditStatus Stock edit status
     *
     * @return self
     */
    public function setStockEditStatus(?bool $stockEditStatus): self
    {
        $this->container['stockEditStatus'] = $stockEditStatus;
        return $this;
    }

    /**
     * Gets skuId
     *
     * @return int|null
     */
    public function getSkuId(): ?int
    {
        return $this->container['skuId'] ?? null;
    }

    /**
     * Sets skuId
     *
     * @param int|null $skuId SKU Id
     *
     * @return self
     */
    public function setSkuId(?int $skuId): self
    {
        $this->container['skuId'] = $skuId;
        return $this;
    }

    /**
     * Gets goodsId
     *
     * @return int|null
     */
    public function getGoodsId(): ?int
    {
        return $this->container['goodsId'] ?? null;
    }

    /**
     * Sets goodsId
     *
     * @param int|null $goodsId Goods Id
     *
     * @return self
     */
    public function setGoodsId(?int $goodsId): self
    {
        $this->container['goodsId'] = $goodsId;
        return $this;
    }

    /**
     * Gets errorMsg
     *
     * @return string|null
     */
    public function getErrorMsg(): ?string
    {
        return $this->container['errorMsg'] ?? null;
    }

    /**
     * Sets errorMsg
     *
     * @param string|null $errorMsg Error message
     *
     * @return self
     */
    public function setErrorMsg(?string $errorMsg): self
    {
        $this->container['errorMsg'] = $errorMsg;
        return $this;
    }

    /**
     * Gets skuStockEditStatusInfoList
     *
     * @return \Temu\Model\SkuStockEditStatusInfo[]|null
     */
    public function getSkuStockEditStatusInfoList(): ?array
    {
        return $this->container['skuStockEditStatusInfoList'] ?? null;
    }

    /**
     * Sets skuStockEditStatusInfoList
     *
     * @param \Temu\Model\SkuStockEditStatusInfo[]|null $skuStockEditStatusInfoList Array of SKU stock edit status information
     *
     * @return self
     */
    public function setSkuStockEditStatusInfoList(?array $skuStockEditStatusInfoList): self
    {
        $this->container['skuStockEditStatusInfoList'] = $skuStockEditStatusInfoList;
        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    public function offsetGet($offset): mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @return mixed Returns data which can be serialized by json_encode()
     */
    public function jsonSerialize(): mixed
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString(): string
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR | JSON_PRETTY_PRINT) ?: '';
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue(): string
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
