<?php
/**
 * UpdateGoodsStockRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;
use Temu\ObjectSerializer;

/**
 * UpdateGoodsStockRequest Class - Request model for updateGoodsStock API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class UpdateGoodsStockRequest extends BaseRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'UpdateGoodsStockRequest';

    protected static array $openAPITypes = [
        'type' => 'string',
        'goodsId' => 'int',
        'stockType' => 'int',
        'requestUniqueKey' => 'string',
        'skuStockTargetList' => '\Temu\Model\SkuStockTarget[]',
        'skuStockChangeList' => '\Temu\Model\SkuStockChange[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static array $openAPIFormats = [
        'type' => null,
        'goodsId' => 'int64',
        'stockType' => 'int32',
        'requestUniqueKey' => null,
        'skuStockTargetList' => null,
        'skuStockChangeList' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'type' => false,
        'goodsId' => false,
        'stockType' => true,
        'requestUniqueKey' => false,
        'skuStockTargetList' => false,
        'skuStockChangeList' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'type' => 'type',
        'goodsId' => 'goodsId',
        'stockType' => 'stockType',
        'requestUniqueKey' => 'requestUniqueKey',
        'skuStockTargetList' => 'skuStockTargetList',
        'skuStockChangeList' => 'skuStockChangeList'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static array $setters = [
        'type' => 'setType',
        'goodsId' => 'setGoodsId',
        'stockType' => 'setStockType',
        'requestUniqueKey' => 'setRequestUniqueKey',
        'skuStockTargetList' => 'setSkuStockTargetList',
        'skuStockChangeList' => 'setSkuStockChangeList'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static array $getters = [
        'type' => 'getType',
        'goodsId' => 'getGoodsId',
        'stockType' => 'getStockType',
        'requestUniqueKey' => 'getRequestUniqueKey',
        'skuStockTargetList' => 'getSkuStockTargetList',
        'skuStockChangeList' => 'getSkuStockChangeList'
    ];

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected array $container = [];

    protected string $responseClass = UpdateGoodsStockResponse::class;

    public function __construct(int $goodsId, string $requestUniqueKey, array $skuStockTargetList = [], array $skuStockChangeList = [], ?int $stockType = null)
    {
        parent::__construct();
        $this->setType('bg.local.goods.stock.edit');
        $this->setGoodsId($goodsId);
        $this->setRequestUniqueKey($requestUniqueKey);
        if (!empty($skuStockTargetList)) {
            $this->setSkuStockTargetList($skuStockTargetList);
        }
        if (!empty($skuStockChangeList)) {
            $this->setSkuStockChangeList($skuStockChangeList);
        }
        if ($stockType !== null) {
            $this->setStockType($stockType);
        }
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats(): array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap(): array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters(): array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters(): array
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName(): string
    {
        return self::$openAPIModelName;
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties(): array
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid(): bool
    {
        return count($this->listInvalidProperties()) === 0;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType(): ?string
    {
        return $this->container['type'] ?? null;
    }

    /**
     * Sets type
     *
     * @param string $type
     * @return self
     */
    public function setType(string $type): self
    {
        $this->container['type'] = $type;
        return $this;
    }

    public function getGoodsId(): ?int
    {
        return $this->container['goodsId'] ?? null;
    }

    public function setGoodsId(int $goodsId): self
    {
        $this->container['goodsId'] = $goodsId;
        return $this;
    }

    public function getStockType(): ?int
    {
        return $this->container['stockType'] ?? null;
    }

    public function setStockType(int $stockType): self
    {
        $this->container['stockType'] = $stockType;
        return $this;
    }

    public function getRequestUniqueKey(): ?string
    {
        return $this->container['requestUniqueKey'] ?? null;
    }

    public function setRequestUniqueKey(string $requestUniqueKey): self
    {
        $this->container['requestUniqueKey'] = $requestUniqueKey;
        return $this;
    }

    public function getSkuStockTargetList(): ?array
    {
        return $this->container['skuStockTargetList'] ?? null;
    }

    public function setSkuStockTargetList(array $skuStockTargetList): self
    {
        $this->container['skuStockTargetList'] = $skuStockTargetList;
        return $this;
    }

    public function getSkuStockChangeList(): ?array
    {
        return $this->container['skuStockChangeList'] ?? null;
    }

    public function setSkuStockChangeList(array $skuStockChangeList): self
    {
        $this->container['skuStockChangeList'] = $skuStockChangeList;
        return $this;
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }

    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    public function offsetGet($offset): mixed
    {
        return $this->container[$offset] ?? null;
    }

    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize(): mixed
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue(): string
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
