<?php
/**
 * UpdateGoodsSaleStatusResponse
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;

/**
 * UpdateGoodsSaleStatusResponse Class - Response for updateGoodsSaleStatus API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class UpdateGoodsSaleStatusResponse implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'UpdateGoodsSaleStatusResponse';

    protected static array $openAPITypes = [
        'success' => 'bool',
        'error_code' => 'int',
        'error_msg' => 'string',
        'request_id' => 'string',
        'result' => 'array'
    ];

    protected array $container = [];

    public function __construct(?array $data = null)
    {
        $this->container['success'] = $data['success'] ?? null;
        $this->container['error_code'] = $data['error_code'] ?? $data['errorCode'] ?? null;
        $this->container['error_msg'] = $data['error_msg'] ?? $data['errorMsg'] ?? null;
        $this->container['request_id'] = $data['request_id'] ?? $data['requestId'] ?? null;
        $this->container['result'] = $data['result'] ?? null;
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    public function getSuccess(): ?bool
    {
        return $this->container['success'];
    }

    public function setSuccess(?bool $success): self
    {
        $this->container['success'] = $success;
        return $this;
    }

    public function getErrorCode(): ?int
    {
        return $this->container['error_code'];
    }

    public function setErrorCode(?int $errorCode): self
    {
        $this->container['error_code'] = $errorCode;
        return $this;
    }

    public function getErrorMsg(): ?string
    {
        return $this->container['error_msg'];
    }

    public function setErrorMsg(?string $errorMsg): self
    {
        $this->container['error_msg'] = $errorMsg;
        return $this;
    }

    public function getRequestId(): ?string
    {
        return $this->container['request_id'];
    }

    public function setRequestId(?string $requestId): self
    {
        $this->container['request_id'] = $requestId;
        return $this;
    }

    public function getResult(): ?array
    {
        return $this->container['result'];
    }

    public function setResult(?array $result): self
    {
        $this->container['result'] = $result;
        return $this;
    }

    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    public function offsetGet($offset): mixed
    {
        return $this->container[$offset] ?? null;
    }

    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    public function __toString(): string
    {
        return json_encode($this->jsonSerialize());
    }

    public function jsonSerialize(): mixed
    {
        return $this->container;
    }
}
