<?php
/**
 * UpdateGoodsSaleStatusRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;

/**
 * UpdateGoodsSaleStatusRequest Class - Request model for updateGoodsSaleStatus API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class UpdateGoodsSaleStatusRequest extends BaseRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'UpdateGoodsSaleStatusRequest';

    protected static array $openAPITypes = [
        'type' => 'string',
        'goodsId' => 'int',
        'onsale' => 'bool'
    ];

    protected string $responseClass = UpdateGoodsSaleStatusResponse::class;

    public function __construct(int $goodsId, bool $onsale)
    {
        parent::__construct();
        $this->setType('bg.local.goods.sale.status.set');
        $this->setGoodsId($goodsId);
        $this->setOnsale($onsale);
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    public function getGoodsId(): ?int
    {
        return $this->container['goodsId'] ?? null;
    }

    public function setGoodsId(int $goodsId): self
    {
        $this->container['goodsId'] = $goodsId;
        return $this;
    }

    public function getOnsale(): ?bool
    {
        return $this->container['onsale'] ?? null;
    }

    public function setOnsale(bool $onsale): self
    {
        $this->container['onsale'] = $onsale;
        return $this;
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }
}
