<?php
/**
 * UpdateGoodsPriceRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;

/**
 * UpdateGoodsPriceRequest Class - Request model for updateGoodsPrice API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class UpdateGoodsPriceRequest extends BaseRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'UpdateGoodsPriceRequest';

    protected static array $openAPITypes = [
        'type' => 'string',
        'goodsId' => 'int',
        'changeSkuPriceDTOList' => 'array'
    ];

    protected string $responseClass = UpdateGoodsPriceResponse::class;

    public function __construct(int $goodsId, array $changeSkuPriceDTOList)
    {
        parent::__construct();
        $this->setType('bg.local.goods.priceorder.change.sku.price');
        $this->setGoodsId($goodsId);
        $this->setChangeSkuPriceDTOList($changeSkuPriceDTOList);
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    public function getGoodsId(): ?int
    {
        return $this->container['goodsId'] ?? null;
    }

    public function setGoodsId(int $goodsId): self
    {
        $this->container['goodsId'] = $goodsId;
        return $this;
    }

    public function getChangeSkuPriceDTOList(): ?array
    {
        return $this->container['changeSkuPriceDTOList'] ?? null;
    }

    public function setChangeSkuPriceDTOList(array $changeSkuPriceDTOList): self
    {
        $this->container['changeSkuPriceDTOList'] = $changeSkuPriceDTOList;
        return $this;
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }
}
