<?php
/**
 * UpdateGoodsInfoRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;

/**
 * UpdateGoodsInfoRequest Class - Request model for updateGoodsInfo API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class UpdateGoodsInfoRequest extends BaseRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'UpdateGoodsInfoRequest';

    protected static array $openAPITypes = [
        'type' => 'string',
        'goodsData' => 'array'
    ];

    protected string $responseClass = UpdateGoodsInfoResponse::class;

    public function __construct(array $goodsData = [])
    {
        parent::__construct();
        $this->setType('bg.local.goods.update');
        if (!empty($goodsData)) {
            foreach ($goodsData as $key => $value) {
                $this->container[$key] = $value;
            }
        }
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }

    /**
     * Set a property value
     *
     * @param string $key
     * @param mixed $value
     * @return self
     */
    public function set(string $key, $value): self
    {
        $this->container[$key] = $value;
        return $this;
    }

    /**
     * Get a property value
     *
     * @param string $key
     * @return mixed
     */
    public function get(string $key)
    {
        return $this->container[$key] ?? null;
    }
}
