<?php
/**
 * UpdateGoodsInfoPartialRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;

/**
 * UpdateGoodsInfoPartialRequest Class - Request model for updateGoodsInfoPartial API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class UpdateGoodsInfoPartialRequest extends BaseRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'UpdateGoodsInfoPartialRequest';

    protected static array $openAPITypes = [
        'type' => 'string',
        'goodsData' => 'array'
    ];

    protected string $responseClass = UpdateGoodsInfoPartialResponse::class;

    public function __construct(array $goodsData = [])
    {
        parent::__construct();
        $this->setType('bg.local.goods.partial.update');
        if (!empty($goodsData)) {
            foreach ($goodsData as $key => $value) {
                $this->container[$key] = $value;
            }
        }
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }

    public function set(string $key, $value): self
    {
        $this->container[$key] = $value;
        return $this;
    }

    public function get(string $key)
    {
        return $this->container[$key] ?? null;
    }
}
