<?php
/**
 * SubscribeEventsRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

/**
 * SubscribeEventsRequest Class - Request for SubscribeEvents API
 *
 * @category Class
 * @package  Temu
 */
class SubscribeEventsRequest extends BaseRequest
{
    protected string $responseClass = SubscribeEventsResponse::class;

    protected static $openAPITypes = [
        'cancel_event_code_list' => 'array',
        'permit_event_code_list' => 'array'
    ];

    protected static $attributeMap = [
        'cancel_event_code_list' => 'cancelEventCodeList',
        'permit_event_code_list' => 'permitEventCodeList'
    ];

    public function __construct(
        array $cancelEventCodeList = [],
        array $permitEventCodeList = []
    ) {
        parent::__construct();
        $this->setType('bg.tmc.message.update');
        if (!empty($cancelEventCodeList)) {
            $this->setCancelEventCodeList($cancelEventCodeList);
        }
        if (!empty($permitEventCodeList)) {
            $this->setPermitEventCodeList($permitEventCodeList);
        }
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }

    public function getCancelEventCodeList(): ?array
    {
        return $this->container['cancel_event_code_list'] ?? [];
    }

    public function setCancelEventCodeList(array $cancelEventCodeList): self
    {
        $this->container['cancel_event_code_list'] = $cancelEventCodeList;
        return $this;
    }

    public function getPermitEventCodeList(): ?array
    {
        return $this->container['permit_event_code_list'] ?? [];
    }

    public function setPermitEventCodeList(array $permitEventCodeList): self
    {
        $this->container['permit_event_code_list'] = $permitEventCodeList;
        return $this;
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes + parent::openAPITypes();
    }

    public static function attributeMap(): array
    {
        return self::$attributeMap + parent::attributeMap();
    }
}
