<?php
/**
 * SkuStockTarget
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;
use Temu\ObjectSerializer;

/**
 * SkuStockTarget Class Doc Comment
 *
 * Represents a SKU stock target item for absolute stock updates
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class SkuStockTarget implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static string $openAPIModelName = 'SkuStockTarget';

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'skuId' => 'int',
        'outSkuSn' => 'string',
        'stockTarget' => 'int'
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @var string[]
     */
    protected static array $openAPIFormats = [
        'skuId' => 'int64',
        'outSkuSn' => null,
        'stockTarget' => 'int32'
    ];

    /**
     * Array of nullable properties. Used for (de)serialization
     *
     * @var boolean[]
     */
    protected static array $openAPINullables = [
        'skuId' => false,
        'outSkuSn' => false,
        'stockTarget' => false
    ];

    /**
     * If a nullable field gets set to null, insert it here
     *
     * @var boolean[]
     */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats(): array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'skuId' => 'skuId',
        'outSkuSn' => 'outSkuSn',
        'stockTarget' => 'stockTarget'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static array $setters = [
        'skuId' => 'setSkuId',
        'outSkuSn' => 'setOutSkuSn',
        'stockTarget' => 'setStockTarget'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static array $getters = [
        'skuId' => 'getSkuId',
        'outSkuSn' => 'getOutSkuSn',
        'stockTarget' => 'getStockTarget'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap(): array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters(): array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters(): array
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName(): string
    {
        return self::$openAPIModelName;
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor
     *
     * @param int|null $stockTarget Stock target value, when you set the target stock value, sku's stock will be updated to the target level (required)
     * @param int|null $skuId Goods Sku Id (optional, one of skuId or outSkuSn required)
     * @param string|null $outSkuSn Out Sku Sn (optional, one of skuId or outSkuSn required)
     */
    public function __construct(?int $stockTarget = null, ?int $skuId = null, ?string $outSkuSn = null)
    {
        // Support both legacy constructor signature and array-based initialization
        if (is_array($stockTarget)) {
            // Array-based initialization
            $data = $stockTarget;
            $this->setIfExists('skuId', $data, null);
            $this->setIfExists('outSkuSn', $data, null);
            $this->setIfExists('stockTarget', $data, null);
        } else {
            // Legacy parameter-based initialization
            if ($stockTarget !== null) {
                $this->setStockTarget($stockTarget);
            }
            if ($skuId !== null) {
                $this->setSkuId($skuId);
            }
            if ($outSkuSn !== null) {
                $this->setOutSkuSn($outSkuSn);
            }
        }
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties(): array
    {
        $invalidProperties = [];

        if (!isset($this->container['stockTarget'])) {
            $invalidProperties[] = "'stockTarget' is required";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid(): bool
    {
        return count($this->listInvalidProperties()) === 0;
    }

    /**
     * Gets skuId
     *
     * @return int|null
     */
    public function getSkuId(): ?int
    {
        return $this->container['skuId'] ?? null;
    }

    /**
     * Sets skuId
     *
     * @param int $skuId Goods Sku Id
     *
     * @return self
     */
    public function setSkuId(int $skuId): self
    {
        $this->container['skuId'] = $skuId;
        return $this;
    }

    /**
     * Gets outSkuSn
     *
     * @return string|null
     */
    public function getOutSkuSn(): ?string
    {
        return $this->container['outSkuSn'] ?? null;
    }

    /**
     * Sets outSkuSn
     *
     * @param string $outSkuSn Out Sku Sn
     *
     * @return self
     */
    public function setOutSkuSn(string $outSkuSn): self
    {
        $this->container['outSkuSn'] = $outSkuSn;
        return $this;
    }

    /**
     * Gets stockTarget
     *
     * @return int|null
     */
    public function getStockTarget(): ?int
    {
        return $this->container['stockTarget'] ?? null;
    }

    /**
     * Sets stockTarget
     *
     * @param int $stockTarget Stock target value, when you set the target stock value, sku's stock will be updated to the target level
     *
     * @return self
     */
    public function setStockTarget(int $stockTarget): self
    {
        $this->container['stockTarget'] = $stockTarget;
        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    public function offsetGet($offset): mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @return mixed Returns data which can be serialized by json_encode()
     */
    public function jsonSerialize(): mixed
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString(): string
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR | JSON_PRETTY_PRINT) ?: '';
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue(): string
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}