<?php
/**
 * SkuStockEditStatusInfo
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;
use Temu\ObjectSerializer;

/**
 * SkuStockEditStatusInfo Class Doc Comment
 *
 * Represents the status information for a SKU stock edit operation
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class SkuStockEditStatusInfo implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static string $openAPIModelName = 'SkuStockEditStatusInfo';

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'skuId' => 'int',
        'outSkuSn' => 'string',
        'stockEditStatus' => 'bool',
        'operateResult' => 'bool',
        'msg' => 'string'
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @var string[]
     */
    protected static array $openAPIFormats = [
        'skuId' => 'int64',
        'outSkuSn' => null,
        'stockEditStatus' => null,
        'operateResult' => null,
        'msg' => null
    ];

    /**
     * Array of nullable properties. Used for (de)serialization
     *
     * @var boolean[]
     */
    protected static array $openAPINullables = [
        'skuId' => false,
        'outSkuSn' => false,
        'stockEditStatus' => false,
        'operateResult' => false,
        'msg' => false
    ];

    /**
     * If a nullable field gets set to null, insert it here
     *
     * @var boolean[]
     */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats(): array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->openAPINullablesSetToNull, true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'skuId' => 'skuId',
        'outSkuSn' => 'outSkuSn',
        'stockEditStatus' => 'stockEditStatus',
        'operateResult' => 'operateResult',
        'msg' => 'msg'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static array $setters = [
        'skuId' => 'setSkuId',
        'outSkuSn' => 'setOutSkuSn',
        'stockEditStatus' => 'setStockEditStatus',
        'operateResult' => 'setOperateResult',
        'msg' => 'setMsg'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static array $getters = [
        'skuId' => 'getSkuId',
        'outSkuSn' => 'getOutSkuSn',
        'stockEditStatus' => 'getStockEditStatus',
        'operateResult' => 'getOperateResult',
        'msg' => 'getMsg'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap(): array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters(): array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters(): array
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName(): string
    {
        return self::$openAPIModelName;
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor
     *
     * @param array|null $data Associated array of property values
     */
    public function __construct(?array $data = null)
    {
        $this->container['skuId'] = $data['skuId'] ?? null;
        $this->container['outSkuSn'] = $data['outSkuSn'] ?? null;
        $this->container['stockEditStatus'] = $data['stockEditStatus'] ?? null;
        $this->container['operateResult'] = $data['operateResult'] ?? null;
        $this->container['msg'] = $data['msg'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties(): array
    {
        return [];
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid(): bool
    {
        return count($this->listInvalidProperties()) === 0;
    }

    /**
     * Gets skuId
     *
     * @return int|null
     */
    public function getSkuId(): ?int
    {
        return $this->container['skuId'] ?? null;
    }

    /**
     * Sets skuId
     *
     * @param int|null $skuId Goods Sku Id
     *
     * @return self
     */
    public function setSkuId(?int $skuId): self
    {
        $this->container['skuId'] = $skuId;
        return $this;
    }

    /**
     * Gets outSkuSn
     *
     * @return string|null
     */
    public function getOutSkuSn(): ?string
    {
        return $this->container['outSkuSn'] ?? null;
    }

    /**
     * Sets outSkuSn
     *
     * @param string|null $outSkuSn Out Sku Sn
     *
     * @return self
     */
    public function setOutSkuSn(?string $outSkuSn): self
    {
        $this->container['outSkuSn'] = $outSkuSn;
        return $this;
    }

    /**
     * Gets stockEditStatus
     *
     * @return bool|null
     */
    public function getStockEditStatus(): ?bool
    {
        return $this->container['stockEditStatus'] ?? null;
    }

    /**
     * Sets stockEditStatus
     *
     * @param bool|null $stockEditStatus Stock Edit Status, if true means successful stock modification
     *
     * @return self
     */
    public function setStockEditStatus(?bool $stockEditStatus): self
    {
        $this->container['stockEditStatus'] = $stockEditStatus;
        return $this;
    }

    /**
     * Gets operateResult
     *
     * @return bool|null
     */
    public function getOperateResult(): ?bool
    {
        return $this->container['operateResult'] ?? null;
    }

    /**
     * Sets operateResult
     *
     * @param bool|null $operateResult Stock change result, if true means success
     *
     * @return self
     */
    public function setOperateResult(?bool $operateResult): self
    {
        $this->container['operateResult'] = $operateResult;
        return $this;
    }

    /**
     * Gets msg
     *
     * @return string|null
     */
    public function getMsg(): ?string
    {
        return $this->container['msg'] ?? null;
    }

    /**
     * Sets msg
     *
     * @param string|null $msg Result detail information
     *
     * @return self
     */
    public function setMsg(?string $msg): self
    {
        $this->container['msg'] = $msg;
        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    public function offsetGet($offset): mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @return mixed Returns data which can be serialized by json_encode()
     */
    public function jsonSerialize(): mixed
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString(): string
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR | JSON_PRETTY_PRINT) ?: '';
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue(): string
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}