<?php
/**
 * ShippingServicesRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

/**
 * ShippingServicesRequest Class - Request for GetShippingServices API
 *
 * @category Class
 * @package  Temu
 */
class ShippingServicesRequest extends BaseRequest
{
    protected string $responseClass = ShippingServicesResponse::class;

    protected static $openAPITypes = [
        'warehouse_id' => 'string',
        'length' => 'float',
        'width' => 'float',
        'height' => 'float',
        'weight' => 'float',
        'dimension_unit' => 'string',
        'weight_unit' => 'string',
        'order_sn_list' => 'array'
    ];

    protected static $attributeMap = [
        'warehouse_id' => 'warehouse_id',
        'length' => 'length',
        'width' => 'width',
        'height' => 'height',
        'weight' => 'weight',
        'dimension_unit' => 'dimensionUnit',
        'weight_unit' => 'weightUnit',
        'order_sn_list' => 'orderSnList'
    ];

    public function __construct(
        string $warehouseId,
        float $length,
        float $width,
        float $height,
        float $weight,
        string $dimensionUnit,
        string $weightUnit,
        array $orderSnList
    ) {
        parent::__construct();
        $this->setType('bg.logistics.shippingservices.get');
        $this->setWarehouseId($warehouseId);
        $this->setLength($length);
        $this->setWidth($width);
        $this->setHeight($height);
        $this->setWeight($weight);
        $this->setDimensionUnit($dimensionUnit);
        $this->setWeightUnit($weightUnit);
        $this->setOrderSnList($orderSnList);
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }

    public function getWarehouseId(): string
    {
        return $this->container['warehouse_id'];
    }

    public function setWarehouseId(string $warehouseId): self
    {
        $this->container['warehouse_id'] = $warehouseId;
        return $this;
    }

    public function getLength(): float
    {
        return $this->container['length'];
    }

    public function setLength(float $length): self
    {
        $this->container['length'] = $length;
        return $this;
    }

    public function getWidth(): float
    {
        return $this->container['width'];
    }

    public function setWidth(float $width): self
    {
        $this->container['width'] = $width;
        return $this;
    }

    public function getHeight(): float
    {
        return $this->container['height'];
    }

    public function setHeight(float $height): self
    {
        $this->container['height'] = $height;
        return $this;
    }

    public function getWeight(): float
    {
        return $this->container['weight'];
    }

    public function setWeight(float $weight): self
    {
        $this->container['weight'] = $weight;
        return $this;
    }

    public function getDimensionUnit(): string
    {
        return $this->container['dimension_unit'];
    }

    public function setDimensionUnit(string $dimensionUnit): self
    {
        $this->container['dimension_unit'] = $dimensionUnit;
        return $this;
    }

    public function getWeightUnit(): string
    {
        return $this->container['weight_unit'];
    }

    public function setWeightUnit(string $weightUnit): self
    {
        $this->container['weight_unit'] = $weightUnit;
        return $this;
    }

    public function getOrderSnList(): array
    {
        return $this->container['order_sn_list'];
    }

    public function setOrderSnList(array $orderSnList): self
    {
        $this->container['order_sn_list'] = $orderSnList;
        return $this;
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes + parent::openAPITypes();
    }

    public static function attributeMap(): array
    {
        return self::$attributeMap + parent::attributeMap();
    }
}
