<?php
/**
 * ShippingLabelRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

/**
 * ShippingLabelRequest Class - Request for GetShippingLabel API
 *
 * @category Class
 * @package  Temu
 */
class ShippingLabelRequest extends BaseRequest
{
    protected string $responseClass = ShippingLabelResponse::class;

    protected static $openAPITypes = [
        'package_sn_list' => 'array'
    ];

    protected static $attributeMap = [
        'package_sn_list' => 'packageSnList'
    ];

    public function __construct(array $packageSnList)
    {
        parent::__construct();
        $this->setType('bg.logistics.shipment.document.get');
        $this->setPackageSnList($packageSnList);
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }

    public function getPackageSnList(): array
    {
        return $this->container['package_sn_list'];
    }

    public function setPackageSnList(array $packageSnList): self
    {
        $this->container['package_sn_list'] = $packageSnList;
        return $this;
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes + parent::openAPITypes();
    }

    public static function attributeMap(): array
    {
        return self::$attributeMap + parent::attributeMap();
    }
}
