<?php
/**
 * ShipLaterPackagesRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

/**
 * ShipLaterPackagesRequest Class - Request for GetShipLaterPackages API
 *
 * @category Class
 * @package  Temu
 */
class ShipLaterPackagesRequest extends BaseRequest
{
    protected string $responseClass = ShipLaterPackagesResponse::class;

    protected static $openAPITypes = [
        'page_size' => 'int',
        'page_number' => 'int'
    ];

    protected static $attributeMap = [
        'page_size' => 'page_size',
        'page_number' => 'page_number'
    ];

    public function __construct(int $pageSize, int $pageNumber)
    {
        parent::__construct();
        $this->setType('bg.order.unshipped.package.get');
        $this->setPageSize($pageSize);
        $this->setPageNumber($pageNumber);
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }

    public function getPageSize(): int
    {
        return $this->container['page_size'];
    }

    public function setPageSize(int $pageSize): self
    {
        $this->container['page_size'] = $pageSize;
        return $this;
    }

    public function getPageNumber(): int
    {
        return $this->container['page_number'];
    }

    public function setPageNumber(int $pageNumber): self
    {
        $this->container['page_number'] = $pageNumber;
        return $this;
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes + parent::openAPITypes();
    }

    public static function attributeMap(): array
    {
        return self::$attributeMap + parent::attributeMap();
    }
}
