<?php
/**
 * ReturnOrderListRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

/**
 * ReturnOrderListRequest Class - Request for GetReturnOrderList API
 *
 * @category Class
 * @package  Temu
 */
class ReturnOrderListRequest extends BaseRequest
{
    protected string $responseClass = ReturnOrderListResponse::class;

    protected static $openAPITypes = [
        'parent_after_sales_sn' => 'string',
        'after_sales_sn' => 'string'
    ];

    protected static $attributeMap = [
        'parent_after_sales_sn' => 'parentAfterSalesSn',
        'after_sales_sn' => 'afterSalesSn'
    ];

    public function __construct(
        string $parentAfterSalesSn,
        string $afterSalesSn
    ) {
        parent::__construct();
        $this->setType('bg.aftersales.parentreturnorder.get');
        $this->setParentAfterSalesSn($parentAfterSalesSn);
        $this->setAfterSalesSn($afterSalesSn);
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }

    public function getParentAfterSalesSn(): string
    {
        return $this->container['parent_after_sales_sn'];
    }

    public function setParentAfterSalesSn(string $parentAfterSalesSn): self
    {
        $this->container['parent_after_sales_sn'] = $parentAfterSalesSn;
        return $this;
    }

    public function getAfterSalesSn(): string
    {
        return $this->container['after_sales_sn'];
    }

    public function setAfterSalesSn(string $afterSalesSn): self
    {
        $this->container['after_sales_sn'] = $afterSalesSn;
        return $this;
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes + parent::openAPITypes();
    }

    public static function attributeMap(): array
    {
        return self::$attributeMap + parent::attributeMap();
    }
}
