<?php
/**
 * RejectGoodsPriceOrderRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;

/**
 * RejectGoodsPriceOrderRequest Class - Request model for rejectGoodsPriceOrder API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class RejectGoodsPriceOrderRequest extends BaseRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'RejectGoodsPriceOrderRequest';

    protected static array $openAPITypes = [
        'type' => 'string',
        'rejectDelist' => 'bool',
        'priceOrderBaseList' => 'array'
    ];

    protected string $responseClass = RejectGoodsPriceOrderResponse::class;

    public function __construct(bool $rejectDelist, array $priceOrderBaseList)
    {
        parent::__construct();
        $this->setType('temu.local.goods.priceorder.reject');
        $this->setRejectDelist($rejectDelist);
        $this->setPriceOrderBaseList($priceOrderBaseList);
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    public function getRejectDelist(): ?bool
    {
        return $this->container['rejectDelist'] ?? null;
    }

    public function setRejectDelist(bool $rejectDelist): self
    {
        $this->container['rejectDelist'] = $rejectDelist;
        return $this;
    }

    public function getPriceOrderBaseList(): ?array
    {
        return $this->container['priceOrderBaseList'] ?? null;
    }

    public function setPriceOrderBaseList(array $priceOrderBaseList): self
    {
        $this->container['priceOrderBaseList'] = $priceOrderBaseList;
        return $this;
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }
}
