<?php
/**
 * RecommendPropertiesRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

/**
 * RecommendPropertiesRequest Class - Request for RecommendProperties API
 *
 * @category Class
 * @package  Temu
 */
class RecommendPropertiesRequest extends BaseRequest
{
    protected string $responseClass = RecommendPropertiesResponse::class;

    protected static $openAPITypes = [
        'cat_id' => 'int',
        'goods_name' => 'string',
        'goods_prop_list' => 'array'
    ];

    protected static $attributeMap = [
        'cat_id' => 'catId',
        'goods_name' => 'goodsName',
        'goods_prop_list' => 'goodsPropList'
    ];

    public function __construct(
        int $catId,
        string $goodsName,
        array $goodsPropList
    ) {
        parent::__construct();
        $this->setType('bg.local.goods.property.get');
        $this->setCatId($catId);
        $this->setGoodsName($goodsName);
        $this->setGoodsPropList($goodsPropList);
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }

    public function getCatId(): int
    {
        return $this->container['cat_id'];
    }

    public function setCatId(int $catId): self
    {
        $this->container['cat_id'] = $catId;
        return $this;
    }

    public function getGoodsName(): string
    {
        return $this->container['goods_name'];
    }

    public function setGoodsName(string $goodsName): self
    {
        $this->container['goods_name'] = $goodsName;
        return $this;
    }

    public function getGoodsPropList(): array
    {
        return $this->container['goods_prop_list'];
    }

    public function setGoodsPropList(array $goodsPropList): self
    {
        $this->container['goods_prop_list'] = $goodsPropList;
        return $this;
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes + parent::openAPITypes();
    }

    public static function attributeMap(): array
    {
        return self::$attributeMap + parent::attributeMap();
    }
}
