<?php
/**
 * RecommendCategoriesRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

/**
 * RecommendCategoriesRequest Class - Request for RecommendCategories API
 *
 * @category Class
 * @package  Temu
 */
class RecommendCategoriesRequest extends BaseRequest
{
    protected string $responseClass = RecommendCategoriesResponse::class;

    protected static $openAPITypes = [
        'goods_name' => 'string'
    ];

    protected static $attributeMap = [
        'goods_name' => 'goodsName'
    ];

    public function __construct(string $goodsName)
    {
        parent::__construct();
        $this->setType('bg.local.goods.category.recommend');
        $this->setGoodsName($goodsName);
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }

    public function getGoodsName(): string
    {
        return $this->container['goods_name'];
    }

    public function setGoodsName(string $goodsName): self
    {
        $this->container['goods_name'] = $goodsName;
        return $this;
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes + parent::openAPITypes();
    }

    public static function attributeMap(): array
    {
        return self::$attributeMap + parent::attributeMap();
    }
}
