<?php
/**
 * ProductItem
 * PHP version 8.1
 */

namespace Temu\Model;

use ArrayAccess;
use Temu\ObjectSerializer;

class ProductItem implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;
    protected static string $openAPIModelName = 'ProductItem';

    protected static array $openAPITypes = [
        'productId' => 'int',
        'productSkuId' => 'int',
        'soldFactor' => 'int',
        'extCode' => 'string'
    ];
    protected static array $openAPIFormats = [
        'productId' => null,
        'productSkuId' => null,
        'soldFactor' => null,
        'extCode' => null
    ];
    protected static array $openAPINullables = [
        'productId' => false,
        'productSkuId' => false,
        'soldFactor' => false,
        'extCode' => false
    ];
    protected static array $attributeMap = [
        'productId' => 'productId',
        'productSkuId' => 'productSkuId',
        'soldFactor' => 'soldFactor',
        'extCode' => 'extCode'
    ];
    protected static array $setters = [
        'productId' => 'setProductId',
        'productSkuId' => 'setProductSkuId',
        'soldFactor' => 'setSoldFactor',
        'extCode' => 'setExtCode'
    ];
    protected static array $getters = [
        'productId' => 'getProductId',
        'productSkuId' => 'getProductSkuId',
        'soldFactor' => 'getSoldFactor',
        'extCode' => 'getExtCode'
    ];

    protected array $container = [];

    public function __construct(?array $data = null)
    {
        $this->container['productId'] = $data['productId'] ?? null;
        $this->container['productSkuId'] = $data['productSkuId'] ?? null;
        $this->container['soldFactor'] = $data['soldFactor'] ?? null;
        $this->container['extCode'] = $data['extCode'] ?? null;
    }

    public static function openAPITypes(): array { return self::$openAPITypes; }
    public static function openAPIFormats(): array { return self::$openAPIFormats; }
    public static function attributeMap(): array { return self::$attributeMap; }
    public static function setters(): array { return self::$setters; }
    public static function getters(): array { return self::$getters; }
    public static function isNullable(string $property): bool { return self::$openAPINullables[$property] ?? false; }
    public function isNullableSetToNull(string $property): bool { return false; }
    public function getModelName(): string { return self::$openAPIModelName; }
    public function listInvalidProperties(): array { return []; }
    public function valid(): bool { return true; }

    public function offsetExists($offset): bool { return isset($this->container[$offset]); }
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) { return $this->container[$offset] ?? null; }
    public function offsetSet($offset, $value): void { $this->container[is_null($offset) ? count($this->container) : $offset] = $value; }
    public function offsetUnset($offset): void { unset($this->container[$offset]); }

    #[\ReturnTypeWillChange]
    public function jsonSerialize(): mixed { return ObjectSerializer::sanitizeForSerialization($this); }
    public function __toString(): string { return json_encode($this->jsonSerialize(), JSON_PRETTY_PRINT); }
}
