<?php
/**
 * PostRequest
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Temu Open APIs
 *
 * Comprehensive API collection for Temu marketplace operations including product management, order processing, inventory management, pricing, and fulfillment services.  All endpoints use POST method with operation type specified in request body. Authentication uses MD5 signature with app_key, app_secret, access_token, and timestamp.
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.1.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Temu\Model;

use \ArrayAccess;
use \Temu\ObjectSerializer;

/**
 * PostRequest Class Doc Comment
 *
 * Universal request wrapper for Temu's single-endpoint API architecture.
 *
 * Temu uses a unique API design where ALL operations POST to a single endpoint,
 * with the operation type specified in the request body via the 'type' field.
 * This class serves as a discriminated union that can represent any API operation.
 *
 * **Architecture Pattern:**
 * - **Single Endpoint:** All requests go to `/openapi/router`
 * - **Operation Selection:** Determined by the 'type' field (e.g., 'bg.goods.list.get')
 * - **Polymorphic Payload:** Different operations have different required fields
 * - **Discriminator:** The 'type' field acts as the discriminator for deserialization
 *
 * **Operation Type Format:**
 * Operation types follow a hierarchical naming convention:
 * - `bg.oauth.*` - Authentication operations
 * - `bg.local.goods.*` - Product listing/management
 * - `bg.order.*` - Order operations
 * - `bg.logistics.*` - Shipping and fulfillment
 * - `bg.aftersales.*` - Returns and refunds
 *
 * **Note:** In practice, you typically don't use PostRequest directly. Instead, use
 * the specific typed request classes (GoodsListRequest, OrderDetailRequest, etc.)
 * which are automatically wrapped by the API client methods.
 *
 * @category Class
 * @package  Temu
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 *
 * @example Internal usage (handled by SDK)
 * ```php
 * // When you call:
 * $response = $api->getGoodsList($goodsListRequest);
 *
 * // The SDK internally wraps it:
 * $postRequest = new PostRequest();
 * $postRequest->setType('bg.local.goods.list.get');
 * // ... sets other fields from $goodsListRequest
 * // Then POSTs to /openapi/router
 * ```
 *
 * @example Operation type examples
 * ```php
 * // Product operations
 * 'bg.local.goods.list.get'        // Get product list
 * 'bg.goods.detail.get'            // Get product details
 * 'bg.goods.create'                 // Create product
 *
 * // Order operations
 * 'bg.order.list.get'              // Get order list
 * 'bg.order.detail.v2.get'         // Get order details
 *
 * // Logistics operations
 * 'bg.logistics.shipment.create'   // Create shipment
 * ```
 *
 * @see https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.0.md#discriminatorObject
 */
class PostRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    /**
     * Discriminator field name for polymorphic deserialization
     *
     * The 'type' field is used to determine which specific request type
     * this PostRequest represents during deserialization from JSON.
     */
    public const DISCRIMINATOR = 'type';

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = '__post_request';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'type' => 'string',
        'code' => 'string',
        'parent_cat_id' => 'int',
        'goods_basic' => '\Temu\Model\CreateGoodsRequestAllOfGoodsBasic',
        'goods_property' => '\Temu\Model\CreateGoodsRequestAllOfGoodsProperty',
        'sku_list' => 'object[]',
        'parent_order_status' => 'int',
        'region_id' => 'int',
        'page_number' => 'int',
        'page_size' => 'int',
        'parent_order_sn' => 'string',
        'sku_id' => 'string',
        'stock' => 'int',
        'shipping_service_id' => 'string',
        'warehouse_id' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'type' => null,
        'code' => null,
        'parent_cat_id' => null,
        'goods_basic' => null,
        'goods_property' => null,
        'sku_list' => null,
        'parent_order_status' => null,
        'region_id' => null,
        'page_number' => null,
        'page_size' => null,
        'parent_order_sn' => null,
        'sku_id' => null,
        'stock' => null,
        'shipping_service_id' => null,
        'warehouse_id' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'type' => false,
		'code' => false,
		'parent_cat_id' => false,
		'goods_basic' => false,
		'goods_property' => false,
		'sku_list' => false,
		'parent_order_status' => false,
		'region_id' => false,
		'page_number' => false,
		'page_size' => false,
		'parent_order_sn' => false,
		'sku_id' => false,
		'stock' => false,
		'shipping_service_id' => false,
		'warehouse_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats(): array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'type' => 'type',
        'code' => 'code',
        'parent_cat_id' => 'parentCatId',
        'goods_basic' => 'goodsBasic',
        'goods_property' => 'goodsProperty',
        'sku_list' => 'skuList',
        'parent_order_status' => 'parentOrderStatus',
        'region_id' => 'regionId',
        'page_number' => 'pageNumber',
        'page_size' => 'pageSize',
        'parent_order_sn' => 'parentOrderSn',
        'sku_id' => 'skuId',
        'stock' => 'stock',
        'shipping_service_id' => 'shippingServiceId',
        'warehouse_id' => 'warehouseId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'type' => 'setType',
        'code' => 'setCode',
        'parent_cat_id' => 'setParentCatId',
        'goods_basic' => 'setGoodsBasic',
        'goods_property' => 'setGoodsProperty',
        'sku_list' => 'setSkuList',
        'parent_order_status' => 'setParentOrderStatus',
        'region_id' => 'setRegionId',
        'page_number' => 'setPageNumber',
        'page_size' => 'setPageSize',
        'parent_order_sn' => 'setParentOrderSn',
        'sku_id' => 'setSkuId',
        'stock' => 'setStock',
        'shipping_service_id' => 'setShippingServiceId',
        'warehouse_id' => 'setWarehouseId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'type' => 'getType',
        'code' => 'getCode',
        'parent_cat_id' => 'getParentCatId',
        'goods_basic' => 'getGoodsBasic',
        'goods_property' => 'getGoodsProperty',
        'sku_list' => 'getSkuList',
        'parent_order_status' => 'getParentOrderStatus',
        'region_id' => 'getRegionId',
        'page_number' => 'getPageNumber',
        'page_size' => 'getPageSize',
        'parent_order_sn' => 'getParentOrderSn',
        'sku_id' => 'getSkuId',
        'stock' => 'getStock',
        'shipping_service_id' => 'getShippingServiceId',
        'warehouse_id' => 'getWarehouseId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap(): array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters(): array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters(): array
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName(): string
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('code', $data ?? [], null);
        $this->setIfExists('parent_cat_id', $data ?? [], null);
        $this->setIfExists('goods_basic', $data ?? [], null);
        $this->setIfExists('goods_property', $data ?? [], null);
        $this->setIfExists('sku_list', $data ?? [], null);
        $this->setIfExists('parent_order_status', $data ?? [], null);
        $this->setIfExists('region_id', $data ?? [], null);
        $this->setIfExists('page_number', $data ?? [], 1);
        $this->setIfExists('page_size', $data ?? [], 20);
        $this->setIfExists('parent_order_sn', $data ?? [], null);
        $this->setIfExists('sku_id', $data ?? [], null);
        $this->setIfExists('stock', $data ?? [], null);
        $this->setIfExists('shipping_service_id', $data ?? [], null);
        $this->setIfExists('warehouse_id', $data ?? [], null);

        // Initialize discriminator property with the model name.
        $this->container['type'] = static::$openAPIModelName;
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties(): array
    {
        $invalidProperties = [];

        if ($this->container['type'] === null) {
            $invalidProperties[] = "'type' can't be null";
        }
        if ($this->container['code'] === null) {
            $invalidProperties[] = "'code' can't be null";
        }
        if ($this->container['parent_cat_id'] === null) {
            $invalidProperties[] = "'parent_cat_id' can't be null";
        }
        if ($this->container['goods_basic'] === null) {
            $invalidProperties[] = "'goods_basic' can't be null";
        }
        if ($this->container['sku_list'] === null) {
            $invalidProperties[] = "'sku_list' can't be null";
        }
        if (!is_null($this->container['page_number']) && ($this->container['page_number'] < 1)) {
            $invalidProperties[] = "invalid value for 'page_number', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['page_size']) && ($this->container['page_size'] > 100)) {
            $invalidProperties[] = "invalid value for 'page_size', must be smaller than or equal to 100.";
        }

        if (!is_null($this->container['page_size']) && ($this->container['page_size'] < 1)) {
            $invalidProperties[] = "invalid value for 'page_size', must be bigger than or equal to 1.";
        }

        if ($this->container['parent_order_sn'] === null) {
            $invalidProperties[] = "'parent_order_sn' can't be null";
        }
        if ($this->container['sku_id'] === null) {
            $invalidProperties[] = "'sku_id' can't be null";
        }
        if ($this->container['stock'] === null) {
            $invalidProperties[] = "'stock' can't be null";
        }
        if (($this->container['stock'] < 0)) {
            $invalidProperties[] = "invalid value for 'stock', must be bigger than or equal to 0.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid(): bool
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets type
     *
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string $type Operation type identifier
     *
     * @return self
     */
    public function setType($type)
    {
        if (is_null($type)) {
            throw new \InvalidArgumentException('non-nullable type cannot be null');
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets code
     *
     * @return string
     */
    public function getCode()
    {
        return $this->container['code'];
    }

    /**
     * Sets code
     *
     * @param string $code Authorization code
     *
     * @return self
     */
    public function setCode($code)
    {
        if (is_null($code)) {
            throw new \InvalidArgumentException('non-nullable code cannot be null');
        }
        $this->container['code'] = $code;

        return $this;
    }

    /**
     * Gets parent_cat_id
     *
     * @return int
     */
    public function getParentCatId()
    {
        return $this->container['parent_cat_id'];
    }

    /**
     * Sets parent_cat_id
     *
     * @param int $parent_cat_id Parent category ID (0 for root categories)
     *
     * @return self
     */
    public function setParentCatId($parent_cat_id)
    {
        if (is_null($parent_cat_id)) {
            throw new \InvalidArgumentException('non-nullable parent_cat_id cannot be null');
        }
        $this->container['parent_cat_id'] = $parent_cat_id;

        return $this;
    }

    /**
     * Gets goods_basic
     *
     * @return \Temu\Model\CreateGoodsRequestAllOfGoodsBasic
     */
    public function getGoodsBasic()
    {
        return $this->container['goods_basic'];
    }

    /**
     * Sets goods_basic
     *
     * @param \Temu\Model\CreateGoodsRequestAllOfGoodsBasic $goods_basic goods_basic
     *
     * @return self
     */
    public function setGoodsBasic($goods_basic)
    {
        if (is_null($goods_basic)) {
            throw new \InvalidArgumentException('non-nullable goods_basic cannot be null');
        }
        $this->container['goods_basic'] = $goods_basic;

        return $this;
    }

    /**
     * Gets goods_property
     *
     * @return \Temu\Model\CreateGoodsRequestAllOfGoodsProperty|null
     */
    public function getGoodsProperty()
    {
        return $this->container['goods_property'];
    }

    /**
     * Sets goods_property
     *
     * @param \Temu\Model\CreateGoodsRequestAllOfGoodsProperty|null $goods_property goods_property
     *
     * @return self
     */
    public function setGoodsProperty($goods_property)
    {
        if (is_null($goods_property)) {
            throw new \InvalidArgumentException('non-nullable goods_property cannot be null');
        }
        $this->container['goods_property'] = $goods_property;

        return $this;
    }

    /**
     * Gets sku_list
     *
     * @return object[]
     */
    public function getSkuList()
    {
        return $this->container['sku_list'];
    }

    /**
     * Sets sku_list
     *
     * @param object[] $sku_list sku_list
     *
     * @return self
     */
    public function setSkuList($sku_list)
    {
        if (is_null($sku_list)) {
            throw new \InvalidArgumentException('non-nullable sku_list cannot be null');
        }
        $this->container['sku_list'] = $sku_list;

        return $this;
    }

    /**
     * Gets parent_order_status
     *
     * @return int|null
     */
    public function getParentOrderStatus()
    {
        return $this->container['parent_order_status'];
    }

    /**
     * Sets parent_order_status
     *
     * @param int|null $parent_order_status Order status filter
     *
     * @return self
     */
    public function setParentOrderStatus($parent_order_status)
    {
        if (is_null($parent_order_status)) {
            throw new \InvalidArgumentException('non-nullable parent_order_status cannot be null');
        }
        $this->container['parent_order_status'] = $parent_order_status;

        return $this;
    }

    /**
     * Gets region_id
     *
     * @return int|null
     */
    public function getRegionId()
    {
        return $this->container['region_id'];
    }

    /**
     * Sets region_id
     *
     * @param int|null $region_id Region identifier
     *
     * @return self
     */
    public function setRegionId($region_id)
    {
        if (is_null($region_id)) {
            throw new \InvalidArgumentException('non-nullable region_id cannot be null');
        }
        $this->container['region_id'] = $region_id;

        return $this;
    }

    /**
     * Gets page_number
     *
     * @return int|null
     */
    public function getPageNumber()
    {
        return $this->container['page_number'];
    }

    /**
     * Sets page_number
     *
     * @param int|null $page_number page_number
     *
     * @return self
     */
    public function setPageNumber($page_number)
    {
        if (is_null($page_number)) {
            throw new \InvalidArgumentException('non-nullable page_number cannot be null');
        }

        if (($page_number < 1)) {
            throw new \InvalidArgumentException('invalid value for $page_number when calling PostRequest., must be bigger than or equal to 1.');
        }

        $this->container['page_number'] = $page_number;

        return $this;
    }

    /**
     * Gets page_size
     *
     * @return int|null
     */
    public function getPageSize()
    {
        return $this->container['page_size'];
    }

    /**
     * Sets page_size
     *
     * @param int|null $page_size page_size
     *
     * @return self
     */
    public function setPageSize($page_size)
    {
        if (is_null($page_size)) {
            throw new \InvalidArgumentException('non-nullable page_size cannot be null');
        }

        if (($page_size > 100)) {
            throw new \InvalidArgumentException('invalid value for $page_size when calling PostRequest., must be smaller than or equal to 100.');
        }
        if (($page_size < 1)) {
            throw new \InvalidArgumentException('invalid value for $page_size when calling PostRequest., must be bigger than or equal to 1.');
        }

        $this->container['page_size'] = $page_size;

        return $this;
    }

    /**
     * Gets parent_order_sn
     *
     * @return string
     */
    public function getParentOrderSn()
    {
        return $this->container['parent_order_sn'];
    }

    /**
     * Sets parent_order_sn
     *
     * @param string $parent_order_sn parent_order_sn
     *
     * @return self
     */
    public function setParentOrderSn($parent_order_sn)
    {
        if (is_null($parent_order_sn)) {
            throw new \InvalidArgumentException('non-nullable parent_order_sn cannot be null');
        }
        $this->container['parent_order_sn'] = $parent_order_sn;

        return $this;
    }

    /**
     * Gets sku_id
     *
     * @return string
     */
    public function getSkuId()
    {
        return $this->container['sku_id'];
    }

    /**
     * Sets sku_id
     *
     * @param string $sku_id SKU identifier
     *
     * @return self
     */
    public function setSkuId($sku_id)
    {
        if (is_null($sku_id)) {
            throw new \InvalidArgumentException('non-nullable sku_id cannot be null');
        }
        $this->container['sku_id'] = $sku_id;

        return $this;
    }

    /**
     * Gets stock
     *
     * @return int
     */
    public function getStock()
    {
        return $this->container['stock'];
    }

    /**
     * Sets stock
     *
     * @param int $stock Stock quantity
     *
     * @return self
     */
    public function setStock($stock)
    {
        if (is_null($stock)) {
            throw new \InvalidArgumentException('non-nullable stock cannot be null');
        }

        if (($stock < 0)) {
            throw new \InvalidArgumentException('invalid value for $stock when calling PostRequest., must be bigger than or equal to 0.');
        }

        $this->container['stock'] = $stock;

        return $this;
    }

    /**
     * Gets shipping_service_id
     *
     * @return string|null
     */
    public function getShippingServiceId()
    {
        return $this->container['shipping_service_id'];
    }

    /**
     * Sets shipping_service_id
     *
     * @param string|null $shipping_service_id shipping_service_id
     *
     * @return self
     */
    public function setShippingServiceId($shipping_service_id)
    {
        if (is_null($shipping_service_id)) {
            throw new \InvalidArgumentException('non-nullable shipping_service_id cannot be null');
        }
        $this->container['shipping_service_id'] = $shipping_service_id;

        return $this;
    }

    /**
     * Gets warehouse_id
     *
     * @return string|null
     */
    public function getWarehouseId()
    {
        return $this->container['warehouse_id'];
    }

    /**
     * Sets warehouse_id
     *
     * @param string|null $warehouse_id warehouse_id
     *
     * @return self
     */
    public function setWarehouseId($warehouse_id)
    {
        if (is_null($warehouse_id)) {
            throw new \InvalidArgumentException('non-nullable warehouse_id cannot be null');
        }
        $this->container['warehouse_id'] = $warehouse_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize(): mixed
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString(): string
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR | JSON_PRETTY_PRINT) ?: '';

    }
    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue() :string
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}


