<?php
/**
 * PaymentInfo
 * PHP version 8.1
 */

namespace Temu\Model;

use ArrayAccess;
use Temu\ObjectSerializer;

class PaymentInfo implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;
    protected static string $openAPIModelName = 'PaymentInfo';

    protected static array $openAPITypes = [
        'paymentMethod' => 'string',
        'paymentCardBrand' => 'string',
        'paymentProcessorRegister' => 'string',
        'paymentAuthCode' => 'string'
    ];
    protected static array $openAPIFormats = [
        'paymentMethod' => null,
        'paymentCardBrand' => null,
        'paymentProcessorRegister' => null,
        'paymentAuthCode' => null
    ];
    protected static array $openAPINullables = [
        'paymentMethod' => false,
        'paymentCardBrand' => false,
        'paymentProcessorRegister' => false,
        'paymentAuthCode' => false
    ];
    protected static array $attributeMap = [
        'paymentMethod' => 'paymentMethod',
        'paymentCardBrand' => 'paymentCardBrand',
        'paymentProcessorRegister' => 'paymentProcessorRegister',
        'paymentAuthCode' => 'paymentAuthCode'
    ];
    protected static array $setters = [
        'paymentMethod' => 'setPaymentMethod',
        'paymentCardBrand' => 'setPaymentCardBrand',
        'paymentProcessorRegister' => 'setPaymentProcessorRegister',
        'paymentAuthCode' => 'setPaymentAuthCode'
    ];
    protected static array $getters = [
        'paymentMethod' => 'getPaymentMethod',
        'paymentCardBrand' => 'getPaymentCardBrand',
        'paymentProcessorRegister' => 'getPaymentProcessorRegister',
        'paymentAuthCode' => 'getPaymentAuthCode'
    ];

    protected array $container = [];

    public function __construct(?array $data = null)
    {
        $this->container['paymentMethod'] = $data['paymentMethod'] ?? null;
        $this->container['paymentCardBrand'] = $data['paymentCardBrand'] ?? null;
        $this->container['paymentProcessorRegister'] = $data['paymentProcessorRegister'] ?? null;
        $this->container['paymentAuthCode'] = $data['paymentAuthCode'] ?? null;
    }

    public static function openAPITypes(): array { return self::$openAPITypes; }
    public static function openAPIFormats(): array { return self::$openAPIFormats; }
    public static function attributeMap(): array { return self::$attributeMap; }
    public static function setters(): array { return self::$setters; }
    public static function getters(): array { return self::$getters; }
    public static function isNullable(string $property): bool { return self::$openAPINullables[$property] ?? false; }
    public function isNullableSetToNull(string $property): bool { return false; }
    public function getModelName(): string { return self::$openAPIModelName; }
    public function listInvalidProperties(): array { return []; }
    public function valid(): bool { return true; }

    public function offsetExists($offset): bool { return isset($this->container[$offset]); }
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) { return $this->container[$offset] ?? null; }
    public function offsetSet($offset, $value): void { $this->container[is_null($offset) ? count($this->container) : $offset] = $value; }
    public function offsetUnset($offset): void { unset($this->container[$offset]); }

    #[\ReturnTypeWillChange]
    public function jsonSerialize(): mixed { return ObjectSerializer::sanitizeForSerialization($this); }
    public function __toString(): string { return json_encode($this->jsonSerialize(), JSON_PRETTY_PRINT); }
}
