<?php
/**
 * ParentOrderMap
 * PHP version 8.1
 */

namespace Temu\Model;

use ArrayAccess;
use Temu\ObjectSerializer;

class ParentOrderMap implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;
    protected static string $openAPIModelName = 'ParentOrderMap';

    protected static array $openAPITypes = [
        'parentOrderSn' => 'string',
        'parentOrderStatus' => 'int',
        'parentOrderTime' => 'int',
        'expectShipLatestTime' => 'int',
        'parentOrderPendingFinishTime' => 'int',
        'latestDeliveryTime' => 'int',
        'parentShippingTime' => 'int',
        'siteId' => 'int',
        'regionId' => 'int',
        'parentOrderLabel' => '\Temu\Model\ParentOrderLabel[]',
        'fulfillmentWarning' => 'string[]',
        'hasShippingFee' => 'bool',
        'updateTime' => 'int',
        'orderPaymentType' => 'string',
        'batchOrderNumberList' => 'string[]',
        'shippingMethod' => 'int',
        'parentConfirmTime' => 'int',
        'regionName1' => 'string',
        'regionName2' => 'string',
        'regionName3' => 'string',
    ];

    protected array $container = [];

    public function __construct(?array $data = null)
    {
        $this->container['parentOrderSn'] = $data['parentOrderSn'] ?? null;
        $this->container['parentOrderStatus'] = $data['parentOrderStatus'] ?? null;
        $this->container['parentOrderTime'] = $data['parentOrderTime'] ?? null;
        $this->container['expectShipLatestTime'] = $data['expectShipLatestTime'] ?? null;
        $this->container['parentOrderPendingFinishTime'] = $data['parentOrderPendingFinishTime'] ?? null;
        $this->container['latestDeliveryTime'] = $data['latestDeliveryTime'] ?? null;
        $this->container['parentShippingTime'] = $data['parentShippingTime'] ?? null;
        $this->container['siteId'] = $data['siteId'] ?? null;
        $this->container['regionId'] = $data['regionId'] ?? null;
        $this->container['fulfillmentWarning'] = $data['fulfillmentWarning'] ?? null;
        $this->container['hasShippingFee'] = $data['hasShippingFee'] ?? null;
        $this->container['updateTime'] = $data['updateTime'] ?? null;
        $this->container['orderPaymentType'] = $data['orderPaymentType'] ?? null;
        $this->container['batchOrderNumberList'] = $data['batchOrderNumberList'] ?? null;
        $this->container['shippingMethod'] = $data['shippingMethod'] ?? null;
        $this->container['parentConfirmTime'] = $data['parentConfirmTime'] ?? null;
        $this->container['regionName1'] = $data['regionName1'] ?? null;
        $this->container['regionName2'] = $data['regionName2'] ?? null;
        $this->container['regionName3'] = $data['regionName3'] ?? null;

        // Handle parentOrderLabel array of ParentOrderLabel objects
        if (isset($data['parentOrderLabel']) && is_array($data['parentOrderLabel'])) {
            $this->container['parentOrderLabel'] = array_map(
                fn($item) => $item instanceof ParentOrderLabel ? $item : new ParentOrderLabel(is_array($item) ? $item : (array)$item),
                $data['parentOrderLabel']
            );
        } else {
            $this->container['parentOrderLabel'] = null;
        }
    }

    public static function openAPITypes(): array { return self::$openAPITypes; }
    public static function openAPIFormats(): array { return []; }
    public static function attributeMap(): array { return []; }
    public static function setters(): array { return []; }
    public static function getters(): array { return []; }
    public static function isNullable(string $property): bool { return false; }
    public function isNullableSetToNull(string $property): bool { return false; }
    public function getModelName(): string { return self::$openAPIModelName; }
    public function listInvalidProperties(): array { return []; }
    public function valid(): bool { return true; }

    public function offsetExists($offset): bool { return isset($this->container[$offset]); }
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) { return $this->container[$offset] ?? null; }
    public function offsetSet($offset, $value): void { $this->container[is_null($offset) ? count($this->container) : $offset] = $value; }
    public function offsetUnset($offset): void { unset($this->container[$offset]); }

    #[\ReturnTypeWillChange]
    public function jsonSerialize(): mixed { return ObjectSerializer::sanitizeForSerialization($this); }
    public function __toString(): string { return json_encode($this->jsonSerialize(), JSON_PRETTY_PRINT); }
}
