<?php
/**
 * ParentOrderLabel
 * PHP version 8.1
 */

namespace Temu\Model;

use ArrayAccess;
use Temu\ObjectSerializer;

class ParentOrderLabel implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;
    protected static string $openAPIModelName = 'ParentOrderLabel';

    protected static array $openAPITypes = ['name' => 'string', 'value' => 'int'];
    protected static array $openAPIFormats = ['name' => null, 'value' => null];
    protected static array $openAPINullables = ['name' => false, 'value' => false];
    protected static array $attributeMap = ['name' => 'name', 'value' => 'value'];
    protected static array $setters = ['name' => 'setName', 'value' => 'setValue'];
    protected static array $getters = ['name' => 'getName', 'value' => 'getValue'];

    protected array $container = [];

    public function __construct(?array $data = null)
    {
        $this->container['name'] = $data['name'] ?? null;
        $this->container['value'] = $data['value'] ?? null;
    }

    public static function openAPITypes(): array { return self::$openAPITypes; }
    public static function openAPIFormats(): array { return self::$openAPIFormats; }
    public static function attributeMap(): array { return self::$attributeMap; }
    public static function setters(): array { return self::$setters; }
    public static function getters(): array { return self::$getters; }
    public static function isNullable(string $property): bool { return self::$openAPINullables[$property] ?? false; }
    public function isNullableSetToNull(string $property): bool { return false; }
    public function getModelName(): string { return self::$openAPIModelName; }
    public function listInvalidProperties(): array { return []; }
    public function valid(): bool { return true; }

    public function getName(): ?string { return $this->container['name'] ?? null; }
    public function setName(?string $name): self { $this->container['name'] = $name; return $this; }
    public function getValue(): ?int { return $this->container['value'] ?? null; }
    public function setValue(?int $value): self { $this->container['value'] = $value; return $this; }

    public function offsetExists($offset): bool { return isset($this->container[$offset]); }
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) { return $this->container[$offset] ?? null; }
    public function offsetSet($offset, $value): void { $this->container[is_null($offset) ? count($this->container) : $offset] = $value; }
    public function offsetUnset($offset): void { unset($this->container[$offset]); }

    #[\ReturnTypeWillChange]
    public function jsonSerialize(): mixed { return ObjectSerializer::sanitizeForSerialization($this); }
    public function __toString(): string { return json_encode($this->jsonSerialize(), JSON_PRETTY_PRINT); }
}
