<?php
/**
 * ParentAftersaleOrderListRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

/**
 * ParentAftersaleOrderListRequest Class - Request for GetParentAftersaleOrderList API
 *
 * @category Class
 * @package  Temu
 */
class ParentAftersaleOrderListRequest extends BaseRequest
{
    protected string $responseClass = ParentAftersaleOrderListResponse::class;

    protected static $openAPITypes = [
        'page_no' => 'int',
        'page_size' => 'int',
        'after_sales_status_group' => 'int',
        'create_at_start' => 'int',
        'create_at_end' => 'int'
    ];

    protected static $attributeMap = [
        'page_no' => 'pageNo',
        'page_size' => 'pageSize',
        'after_sales_status_group' => 'afterSalesStatusGroup',
        'create_at_start' => 'createAtStart',
        'create_at_end' => 'createAtEnd'
    ];

    public function __construct(
        int $pageNo,
        int $pageSize,
        int $afterSalesStatusGroup,
        int $createAtStart,
        int $createAtEnd
    ) {
        parent::__construct();
        $this->setType('bg.aftersales.parentaftersales.list.get');
        $this->setPageNo($pageNo);
        $this->setPageSize($pageSize);
        $this->setAfterSalesStatusGroup($afterSalesStatusGroup);
        $this->setCreateAtStart($createAtStart);
        $this->setCreateAtEnd($createAtEnd);
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }

    public function getPageNo(): int
    {
        return $this->container['page_no'];
    }

    public function setPageNo(int $pageNo): self
    {
        $this->container['page_no'] = $pageNo;
        return $this;
    }

    public function getPageSize(): int
    {
        return $this->container['page_size'];
    }

    public function setPageSize(int $pageSize): self
    {
        $this->container['page_size'] = $pageSize;
        return $this;
    }

    public function getAfterSalesStatusGroup(): int
    {
        return $this->container['after_sales_status_group'];
    }

    public function setAfterSalesStatusGroup(int $afterSalesStatusGroup): self
    {
        $this->container['after_sales_status_group'] = $afterSalesStatusGroup;
        return $this;
    }

    public function getCreateAtStart(): int
    {
        return $this->container['create_at_start'];
    }

    public function setCreateAtStart(int $createAtStart): self
    {
        $this->container['create_at_start'] = $createAtStart;
        return $this;
    }

    public function getCreateAtEnd(): int
    {
        return $this->container['create_at_end'];
    }

    public function setCreateAtEnd(int $createAtEnd): self
    {
        $this->container['create_at_end'] = $createAtEnd;
        return $this;
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes + parent::openAPITypes();
    }

    public static function attributeMap(): array
    {
        return self::$attributeMap + parent::attributeMap();
    }
}
