<?php
/**
 * PackageSnInfo
 * PHP version 8.1
 */

namespace Temu\Model;

use ArrayAccess;
use Temu\ObjectSerializer;

class PackageSnInfo implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;
    protected static string $openAPIModelName = 'PackageSnInfo';

    protected static array $openAPITypes = [
        'packageSn' => 'string',
        'packageDeliveryType' => 'int',
        'callSuccess' => 'bool',
        'packageAbnormalTypeList' => 'string[]'
    ];
    protected static array $openAPIFormats = [
        'packageSn' => null,
        'packageDeliveryType' => null,
        'callSuccess' => null,
        'packageAbnormalTypeList' => null
    ];
    protected static array $openAPINullables = [
        'packageSn' => false,
        'packageDeliveryType' => false,
        'callSuccess' => false,
        'packageAbnormalTypeList' => false
    ];
    protected static array $attributeMap = [
        'packageSn' => 'packageSn',
        'packageDeliveryType' => 'packageDeliveryType',
        'callSuccess' => 'callSuccess',
        'packageAbnormalTypeList' => 'packageAbnormalTypeList'
    ];
    protected static array $setters = [
        'packageSn' => 'setPackageSn',
        'packageDeliveryType' => 'setPackageDeliveryType',
        'callSuccess' => 'setCallSuccess',
        'packageAbnormalTypeList' => 'setPackageAbnormalTypeList'
    ];
    protected static array $getters = [
        'packageSn' => 'getPackageSn',
        'packageDeliveryType' => 'getPackageDeliveryType',
        'callSuccess' => 'getCallSuccess',
        'packageAbnormalTypeList' => 'getPackageAbnormalTypeList'
    ];

    protected array $container = [];

    public function __construct(?array $data = null)
    {
        $this->container['packageSn'] = $data['packageSn'] ?? null;
        $this->container['packageDeliveryType'] = $data['packageDeliveryType'] ?? null;
        $this->container['callSuccess'] = $data['callSuccess'] ?? null;
        $this->container['packageAbnormalTypeList'] = $data['packageAbnormalTypeList'] ?? null;
    }

    public static function openAPITypes(): array { return self::$openAPITypes; }
    public static function openAPIFormats(): array { return self::$openAPIFormats; }
    public static function attributeMap(): array { return self::$attributeMap; }
    public static function setters(): array { return self::$setters; }
    public static function getters(): array { return self::$getters; }
    public static function isNullable(string $property): bool { return self::$openAPINullables[$property] ?? false; }
    public function isNullableSetToNull(string $property): bool { return false; }
    public function getModelName(): string { return self::$openAPIModelName; }
    public function listInvalidProperties(): array { return []; }
    public function valid(): bool { return true; }

    public function offsetExists($offset): bool { return isset($this->container[$offset]); }
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) { return $this->container[$offset] ?? null; }
    public function offsetSet($offset, $value): void { $this->container[is_null($offset) ? count($this->container) : $offset] = $value; }
    public function offsetUnset($offset): void { unset($this->container[$offset]); }

    #[\ReturnTypeWillChange]
    public function jsonSerialize(): mixed { return ObjectSerializer::sanitizeForSerialization($this); }
    public function __toString(): string { return json_encode($this->jsonSerialize(), JSON_PRETTY_PRINT); }
}
