<?php
/**
 * OrderShippingInfoResult
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 */

namespace Temu\Model;

use ArrayAccess;
use Temu\ObjectSerializer;

/**
 * OrderShippingInfoResult Class - Result object containing order shipping address information
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class OrderShippingInfoResult implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'OrderShippingInfoResult';

    protected static array $openAPITypes = [
        'receiptName' => 'string',
        'receiptAdditionalName' => 'string',
        'mobile' => 'string',
        'backupMobile' => 'string',
        'mail' => 'string',
        'taxCode' => 'string',
        'regionName1' => 'string',
        'regionName2' => 'string',
        'regionName3' => 'string',
        'regionName4' => 'string',
        'addressLine1' => 'string',
        'addressLine2' => 'string',
        'addressLine3' => 'string',
        'postCode' => 'string',
        'addressLineAll' => 'string',
        'warning' => '\Temu\Model\AddressWarning'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static array $openAPIFormats = [
        'receiptName' => null,
        'receiptAdditionalName' => null,
        'mobile' => null,
        'backupMobile' => null,
        'mail' => null,
        'taxCode' => null,
        'regionName1' => null,
        'regionName2' => null,
        'regionName3' => null,
        'regionName4' => null,
        'addressLine1' => null,
        'addressLine2' => null,
        'addressLine3' => null,
        'postCode' => null,
        'addressLineAll' => null,
        'warning' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'receiptName' => true,
        'receiptAdditionalName' => true,
        'mobile' => true,
        'backupMobile' => true,
        'mail' => true,
        'taxCode' => true,
        'regionName1' => true,
        'regionName2' => true,
        'regionName3' => true,
        'regionName4' => true,
        'addressLine1' => true,
        'addressLine2' => true,
        'addressLine3' => true,
        'postCode' => true,
        'addressLineAll' => true,
        'warning' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats(): array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'receiptName' => 'receiptName',
        'receiptAdditionalName' => 'receiptAdditionalName',
        'mobile' => 'mobile',
        'backupMobile' => 'backupMobile',
        'mail' => 'mail',
        'taxCode' => 'taxCode',
        'regionName1' => 'regionName1',
        'regionName2' => 'regionName2',
        'regionName3' => 'regionName3',
        'regionName4' => 'regionName4',
        'addressLine1' => 'addressLine1',
        'addressLine2' => 'addressLine2',
        'addressLine3' => 'addressLine3',
        'postCode' => 'postCode',
        'addressLineAll' => 'addressLineAll',
        'warning' => 'warning'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static array $setters = [
        'receiptName' => 'setReceiptName',
        'receiptAdditionalName' => 'setReceiptAdditionalName',
        'mobile' => 'setMobile',
        'backupMobile' => 'setBackupMobile',
        'mail' => 'setMail',
        'taxCode' => 'setTaxCode',
        'regionName1' => 'setRegionName1',
        'regionName2' => 'setRegionName2',
        'regionName3' => 'setRegionName3',
        'regionName4' => 'setRegionName4',
        'addressLine1' => 'setAddressLine1',
        'addressLine2' => 'setAddressLine2',
        'addressLine3' => 'setAddressLine3',
        'postCode' => 'setPostCode',
        'addressLineAll' => 'setAddressLineAll',
        'warning' => 'setWarning'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static array $getters = [
        'receiptName' => 'getReceiptName',
        'receiptAdditionalName' => 'getReceiptAdditionalName',
        'mobile' => 'getMobile',
        'backupMobile' => 'getBackupMobile',
        'mail' => 'getMail',
        'taxCode' => 'getTaxCode',
        'regionName1' => 'getRegionName1',
        'regionName2' => 'getRegionName2',
        'regionName3' => 'getRegionName3',
        'regionName4' => 'getRegionName4',
        'addressLine1' => 'getAddressLine1',
        'addressLine2' => 'getAddressLine2',
        'addressLine3' => 'getAddressLine3',
        'postCode' => 'getPostCode',
        'addressLineAll' => 'getAddressLineAll',
        'warning' => 'getWarning'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap(): array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters(): array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters(): array
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName(): string
    {
        return self::$openAPIModelName;
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('receiptName', $data ?? [], null);
        $this->setIfExists('receiptAdditionalName', $data ?? [], null);
        $this->setIfExists('mobile', $data ?? [], null);
        $this->setIfExists('backupMobile', $data ?? [], null);
        $this->setIfExists('mail', $data ?? [], null);
        $this->setIfExists('taxCode', $data ?? [], null);
        $this->setIfExists('regionName1', $data ?? [], null);
        $this->setIfExists('regionName2', $data ?? [], null);
        $this->setIfExists('regionName3', $data ?? [], null);
        $this->setIfExists('regionName4', $data ?? [], null);
        $this->setIfExists('addressLine1', $data ?? [], null);
        $this->setIfExists('addressLine2', $data ?? [], null);
        $this->setIfExists('addressLine3', $data ?? [], null);
        $this->setIfExists('postCode', $data ?? [], null);
        $this->setIfExists('addressLineAll', $data ?? [], null);
        $this->setIfExists('warning', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties(): array
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid(): bool
    {
        return count($this->listInvalidProperties()) === 0;
    }

    public function getReceiptName(): ?string
    {
        return $this->container['receiptName'];
    }

    public function setReceiptName(?string $receiptName): self
    {
        $this->container['receiptName'] = $receiptName;
        return $this;
    }

    public function getReceiptAdditionalName(): ?string
    {
        return $this->container['receiptAdditionalName'];
    }

    public function setReceiptAdditionalName(?string $receiptAdditionalName): self
    {
        $this->container['receiptAdditionalName'] = $receiptAdditionalName;
        return $this;
    }

    public function getMobile(): ?string
    {
        return $this->container['mobile'];
    }

    public function setMobile(?string $mobile): self
    {
        $this->container['mobile'] = $mobile;
        return $this;
    }

    public function getBackupMobile(): ?string
    {
        return $this->container['backupMobile'];
    }

    public function setBackupMobile(?string $backupMobile): self
    {
        $this->container['backupMobile'] = $backupMobile;
        return $this;
    }

    public function getMail(): ?string
    {
        return $this->container['mail'];
    }

    public function setMail(?string $mail): self
    {
        $this->container['mail'] = $mail;
        return $this;
    }

    public function getTaxCode(): ?string
    {
        return $this->container['taxCode'];
    }

    public function setTaxCode(?string $taxCode): self
    {
        $this->container['taxCode'] = $taxCode;
        return $this;
    }

    public function getRegionName1(): ?string
    {
        return $this->container['regionName1'];
    }

    public function setRegionName1(?string $regionName1): self
    {
        $this->container['regionName1'] = $regionName1;
        return $this;
    }

    public function getRegionName2(): ?string
    {
        return $this->container['regionName2'];
    }

    public function setRegionName2(?string $regionName2): self
    {
        $this->container['regionName2'] = $regionName2;
        return $this;
    }

    public function getRegionName3(): ?string
    {
        return $this->container['regionName3'];
    }

    public function setRegionName3(?string $regionName3): self
    {
        $this->container['regionName3'] = $regionName3;
        return $this;
    }

    public function getRegionName4(): ?string
    {
        return $this->container['regionName4'];
    }

    public function setRegionName4(?string $regionName4): self
    {
        $this->container['regionName4'] = $regionName4;
        return $this;
    }

    public function getAddressLine1(): ?string
    {
        return $this->container['addressLine1'];
    }

    public function setAddressLine1(?string $addressLine1): self
    {
        $this->container['addressLine1'] = $addressLine1;
        return $this;
    }

    public function getAddressLine2(): ?string
    {
        return $this->container['addressLine2'];
    }

    public function setAddressLine2(?string $addressLine2): self
    {
        $this->container['addressLine2'] = $addressLine2;
        return $this;
    }

    public function getAddressLine3(): ?string
    {
        return $this->container['addressLine3'];
    }

    public function setAddressLine3(?string $addressLine3): self
    {
        $this->container['addressLine3'] = $addressLine3;
        return $this;
    }

    public function getPostCode(): ?string
    {
        return $this->container['postCode'];
    }

    public function setPostCode(?string $postCode): self
    {
        $this->container['postCode'] = $postCode;
        return $this;
    }

    public function getAddressLineAll(): ?string
    {
        return $this->container['addressLineAll'];
    }

    public function setAddressLineAll(?string $addressLineAll): self
    {
        $this->container['addressLineAll'] = $addressLineAll;
        return $this;
    }

    public function getWarning(): ?AddressWarning
    {
        return $this->container['warning'];
    }

    public function setWarning(?AddressWarning $warning): self
    {
        $this->container['warning'] = $warning;
        return $this;
    }

    /**
     * Get full address combining all address lines
     *
     * @return string|null
     */
    public function getFullAddress(): ?string
    {
        if ($this->getAddressLineAll()) {
            return $this->getAddressLineAll();
        }

        $parts = array_filter([
            $this->getAddressLine1(),
            $this->getAddressLine2(),
            $this->getAddressLine3()
        ]);

        return !empty($parts) ? implode(', ', $parts) : null;
    }

    /**
     * Get full region name combining all region levels
     *
     * @return string|null
     */
    public function getFullRegionName(): ?string
    {
        $parts = array_filter([
            $this->getRegionName1(),
            $this->getRegionName2(),
            $this->getRegionName3(),
            $this->getRegionName4()
        ]);

        return !empty($parts) ? implode(', ', $parts) : null;
    }

    /**
     * Check if address has a restriction warning
     *
     * @return bool
     */
    public function hasAddressRestriction(): bool
    {
        $warning = $this->getWarning();
        return $warning?->getIsRestriction() === true;
    }

    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    public function offsetGet($offset): mixed
    {
        return $this->container[$offset] ?? null;
    }

    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
