<?php
/**
 * OrderShippingCompaniesRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;

/**
 * OrderShippingCompaniesRequest Class - Request model for getOrderShippingCompanies API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class OrderShippingCompaniesRequest extends BaseRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'OrderShippingCompaniesRequest';

    protected static array $openAPITypes = [
        'type' => 'string',
        'regionId' => 'string'
    ];

    protected string $responseClass = OrderShippingCompaniesResponse::class;

    public function __construct(string $regionId)
    {
        parent::__construct();
        $this->setType('bg.logistics.companies.get');
        $this->setRegionId($regionId);
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    public function getRegionId(): ?string
    {
        return $this->container['regionId'] ?? null;
    }

    public function setRegionId(string $regionId): self
    {
        $this->container['regionId'] = $regionId;
        return $this;
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }
}
