<?php
/**
 * OrderShipmentInfoRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;

/**
 * OrderShipmentInfoRequest Class - Request model for getOrderShipmentInfo API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class OrderShipmentInfoRequest extends BaseRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'OrderShipmentInfoRequest';

    protected static array $openAPITypes = [
        'type' => 'string',
        'parentOrderSn' => 'string',
        'orderSn' => 'string'
    ];

    protected string $responseClass = OrderShipmentInfoResponse::class;

    public function __construct(string $parentOrderSn, string $orderSn)
    {
        parent::__construct();
        $this->setType('bg.logistics.shipment.v2.get');
        $this->setParentOrderSn($parentOrderSn);
        $this->setOrderSn($orderSn);
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    public function getParentOrderSn(): ?string
    {
        return $this->container['parentOrderSn'] ?? null;
    }

    public function setParentOrderSn(string $parentOrderSn): self
    {
        $this->container['parentOrderSn'] = $parentOrderSn;
        return $this;
    }

    public function getOrderSn(): ?string
    {
        return $this->container['orderSn'] ?? null;
    }

    public function setOrderSn(string $orderSn): self
    {
        $this->container['orderSn'] = $orderSn;
        return $this;
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }
}
