<?php
/**
 * OrderPriceRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;

/**
 * OrderPriceRequest Class - Request model for getOrderPrice API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class OrderPriceRequest extends BaseRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'OrderPriceRequest';

    protected static array $openAPITypes = [
        'type' => 'string',
        'parent_order_sn' => 'string'
    ];

    protected string $responseClass = OrderPriceResponse::class;

    public function __construct(string $parentOrderSn)
    {
        parent::__construct();
        $this->setType('bg.order.amount.query');
        $this->setParentOrderSn($parentOrderSn);
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    public function getParentOrderSn(): ?string
    {
        return $this->container['parent_order_sn'] ?? null;
    }

    public function setParentOrderSn(string $parentOrderSn): self
    {
        $this->container['parent_order_sn'] = $parentOrderSn;
        return $this;
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }
}
