<?php
/**
 * OrderListResponse
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;
use Temu\ObjectSerializer;

/**
 * OrderListResponse Class - Response for OrderList API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class OrderListResponse implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'OrderListResponse';

    protected static array $openAPITypes = [
        'success' => 'bool',
        'requestId' => 'string',
        'errorCode' => 'int',
        'errorMsg' => 'string',
        'result' => '\Temu\Model\OrderListResult'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static array $openAPIFormats = [
        'success' => null,
        'requestId' => null,
        'errorCode' => 'int32',
        'errorMsg' => null,
        'result' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'success' => false,
        'requestId' => true,
        'errorCode' => false,
        'errorMsg' => true,
        'result' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'success' => 'success',
        'requestId' => 'requestId',
        'errorCode' => 'errorCode',
        'errorMsg' => 'errorMsg',
        'result' => 'result'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static array $setters = [
        'success' => 'setSuccess',
        'requestId' => 'setRequestId',
        'errorCode' => 'setErrorCode',
        'errorMsg' => 'setErrorMsg',
        'result' => 'setResult'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static array $getters = [
        'success' => 'getSuccess',
        'requestId' => 'getRequestId',
        'errorCode' => 'getErrorCode',
        'errorMsg' => 'getErrorMsg',
        'result' => 'getResult'
    ];

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected array $container = [];

    public function __construct(?array $data = null)
    {
        $this->container['success'] = $data['success'] ?? null;
        $this->container['requestId'] = $data['requestId'] ?? $data['request_id'] ?? null;
        $this->container['errorCode'] = $data['errorCode'] ?? $data['error_code'] ?? null;
        $this->container['errorMsg'] = $data['errorMsg'] ?? $data['error_msg'] ?? null;
        $this->container['result'] = isset($data['result']) && is_array($data['result']) ? new OrderListResult($data['result']) : null;
    }


    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    public static function openAPIFormats(): array
    {
        return self::$openAPIFormats;
    }

    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    public static function attributeMap(): array
    {
        return self::$attributeMap;
    }

    public static function setters(): array
    {
        return self::$setters;
    }

    public static function getters(): array
    {
        return self::$getters;
    }

    public function getModelName(): string
    {
        return self::$openAPIModelName;
    }

    public function listInvalidProperties(): array
    {
        return [];
    }

    public function valid(): bool
    {
        return count($this->listInvalidProperties()) === 0;
    }

    /**
     * Gets success
     *
     * @return bool|null
     */
    public function getSuccess(): ?bool
    {
        return $this->container['success'] ?? null;
    }

    /**
     * Sets success
     *
     * @param bool|null $success Success status
     * @return self
     */
    public function setSuccess(?bool $success): self
    {
        $this->container['success'] = $success;
        return $this;
    }

    /**
     * Gets requestId
     *
     * @return string|null
     */
    public function getRequestId(): ?string
    {
        return $this->container['requestId'] ?? null;
    }

    /**
     * Sets requestId
     *
     * @param string|null $requestId Request ID
     * @return self
     */
    public function setRequestId(?string $requestId): self
    {
        $this->container['requestId'] = $requestId;
        return $this;
    }

    /**
     * Gets errorCode
     *
     * @return int|null
     */
    public function getErrorCode(): ?int
    {
        return $this->container['errorCode'] ?? null;
    }

    /**
     * Sets errorCode
     *
     * @param int|null $errorCode Error code
     * @return self
     */
    public function setErrorCode(?int $errorCode): self
    {
        $this->container['errorCode'] = $errorCode;
        return $this;
    }

    /**
     * Gets errorMsg
     *
     * @return string|null
     */
    public function getErrorMsg(): ?string
    {
        return $this->container['errorMsg'] ?? null;
    }

    /**
     * Sets errorMsg
     *
     * @param string|null $errorMsg Error message
     * @return self
     */
    public function setErrorMsg(?string $errorMsg): self
    {
        $this->container['errorMsg'] = $errorMsg;
        return $this;
    }

    /**
     * Gets result
     *
     * @return \Temu\Model\OrderListResult|null
     */
    public function getResult(): ?OrderListResult
    {
        return $this->container['result'] ?? null;
    }

    /**
     * Sets result
     *
     * @param \Temu\Model\OrderListResult|null $result Result data
     * @return self
     */
    public function setResult(?OrderListResult $result): self
    {
        $this->container['result'] = $result;
        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize(): mixed
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue(): string
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
