<?php
/**
 * OrderListRequest
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Temu Open APIs
 *
 * Comprehensive API collection for Temu marketplace operations including product management, order processing, inventory management, pricing, and fulfillment services.  All endpoints use POST method with operation type specified in request body. Authentication uses MD5 signature with app_key, app_secret, access_token, and timestamp.
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.1.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Temu\Model;

use \ArrayAccess;
use \Temu\ObjectSerializer;

/**
 * OrderListRequest Class - Request model for getOrderList API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class OrderListRequest extends BaseRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'OrderListRequest';

    protected static array $openAPITypes = [
        'type' => 'string',
        'pageNumber' => 'int',
        'pageSize' => 'int',
        'parentOrderStatus' => 'int',
        'parentOrderSnList' => 'string[]',
        'createAfter' => 'int',
        'createBefore' => 'int',
        'expectShipLatestTimeStart' => 'int',
        'expectShipLatestTimeEnd' => 'int',
        'updateAtStart' => 'int',
        'updateAtEnd' => 'int',
        'parentConfirmTimeStart' => 'int',
        'parentConfirmTimeEnd' => 'int',
        'regionId' => 'int',
        'fulfillmentTypeList' => 'string[]',
        'parentOrderLabel' => 'string[]',
        'packageAbnormalTypeList' => 'string[]',
        'sortby' => 'string',
        'hasPreSaleOrder' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static array $openAPIFormats = [
        'type' => null,
        'pageNumber' => null,
        'pageSize' => null,
        'parentOrderStatus' => null,
        'parentOrderSnList' => null,
        'createAfter' => null,
        'createBefore' => null,
        'expectShipLatestTimeStart' => null,
        'expectShipLatestTimeEnd' => null,
        'updateAtStart' => null,
        'updateAtEnd' => null,
        'parentConfirmTimeStart' => null,
        'parentConfirmTimeEnd' => null,
        'regionId' => null,
        'fulfillmentTypeList' => null,
        'parentOrderLabel' => null,
        'packageAbnormalTypeList' => null,
        'sortby' => null,
        'hasPreSaleOrder' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'type' => false,
        'pageNumber' => true,
        'pageSize' => true,
        'parentOrderStatus' => true,
        'parentOrderSnList' => true,
        'createAfter' => true,
        'createBefore' => true,
        'expectShipLatestTimeStart' => true,
        'expectShipLatestTimeEnd' => true,
        'updateAtStart' => true,
        'updateAtEnd' => true,
        'parentConfirmTimeStart' => true,
        'parentConfirmTimeEnd' => true,
        'regionId' => true,
        'fulfillmentTypeList' => true,
        'parentOrderLabel' => true,
        'packageAbnormalTypeList' => true,
        'sortby' => true,
        'hasPreSaleOrder' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats(): array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'type' => 'type',
        'pageNumber' => 'pageNumber',
        'pageSize' => 'pageSize',
        'parentOrderStatus' => 'parentOrderStatus',
        'parentOrderSnList' => 'parentOrderSnList',
        'createAfter' => 'createAfter',
        'createBefore' => 'createBefore',
        'expectShipLatestTimeStart' => 'expectShipLatestTimeStart',
        'expectShipLatestTimeEnd' => 'expectShipLatestTimeEnd',
        'updateAtStart' => 'updateAtStart',
        'updateAtEnd' => 'updateAtEnd',
        'parentConfirmTimeStart' => 'parentConfirmTimeStart',
        'parentConfirmTimeEnd' => 'parentConfirmTimeEnd',
        'regionId' => 'regionId',
        'fulfillmentTypeList' => 'fulfillmentTypeList',
        'parentOrderLabel' => 'parentOrderLabel',
        'packageAbnormalTypeList' => 'packageAbnormalTypeList',
        'sortby' => 'sortby',
        'hasPreSaleOrder' => 'hasPreSaleOrder'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static array $setters = [
        'type' => 'setType',
        'pageNumber' => 'setPageNumber',
        'pageSize' => 'setPageSize',
        'parentOrderStatus' => 'setParentOrderStatus',
        'parentOrderSnList' => 'setParentOrderSnList',
        'createAfter' => 'setCreateAfter',
        'createBefore' => 'setCreateBefore',
        'expectShipLatestTimeStart' => 'setExpectShipLatestTimeStart',
        'expectShipLatestTimeEnd' => 'setExpectShipLatestTimeEnd',
        'updateAtStart' => 'setUpdateAtStart',
        'updateAtEnd' => 'setUpdateAtEnd',
        'parentConfirmTimeStart' => 'setParentConfirmTimeStart',
        'parentConfirmTimeEnd' => 'setParentConfirmTimeEnd',
        'regionId' => 'setRegionId',
        'fulfillmentTypeList' => 'setFulfillmentTypeList',
        'parentOrderLabel' => 'setParentOrderLabel',
        'packageAbnormalTypeList' => 'setPackageAbnormalTypeList',
        'sortby' => 'setSortby',
        'hasPreSaleOrder' => 'setHasPreSaleOrder'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static array $getters = [
        'type' => 'getType',
        'pageNumber' => 'getPageNumber',
        'pageSize' => 'getPageSize',
        'parentOrderStatus' => 'getParentOrderStatus',
        'parentOrderSnList' => 'getParentOrderSnList',
        'createAfter' => 'getCreateAfter',
        'createBefore' => 'getCreateBefore',
        'expectShipLatestTimeStart' => 'getExpectShipLatestTimeStart',
        'expectShipLatestTimeEnd' => 'getExpectShipLatestTimeEnd',
        'updateAtStart' => 'getUpdateAtStart',
        'updateAtEnd' => 'getUpdateAtEnd',
        'parentConfirmTimeStart' => 'getParentConfirmTimeStart',
        'parentConfirmTimeEnd' => 'getParentConfirmTimeEnd',
        'regionId' => 'getRegionId',
        'fulfillmentTypeList' => 'getFulfillmentTypeList',
        'parentOrderLabel' => 'getParentOrderLabel',
        'packageAbnormalTypeList' => 'getPackageAbnormalTypeList',
        'sortby' => 'getSortby',
        'hasPreSaleOrder' => 'getHasPreSaleOrder'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap(): array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters(): array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters(): array
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName(): string
    {
        return self::$openAPIModelName;
    }

    /**
     * The response class for this request
     *
     * @var string
     */
    protected string $responseClass = OrderListResponse::class;

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(?array $data = null)
    {
        parent::__construct();
        $this->setIfExists('type', $data ?? [], 'bg.order.list.v2.get');
        $this->setIfExists('pageNumber', $data ?? [], 1);
        $this->setIfExists('pageSize', $data ?? [], 10);
        $this->setIfExists('parentOrderStatus', $data ?? [], null);
        $this->setIfExists('parentOrderSnList', $data ?? [], null);
        $this->setIfExists('createAfter', $data ?? [], null);
        $this->setIfExists('createBefore', $data ?? [], null);
        $this->setIfExists('expectShipLatestTimeStart', $data ?? [], null);
        $this->setIfExists('expectShipLatestTimeEnd', $data ?? [], null);
        $this->setIfExists('updateAtStart', $data ?? [], null);
        $this->setIfExists('updateAtEnd', $data ?? [], null);
        $this->setIfExists('parentConfirmTimeStart', $data ?? [], null);
        $this->setIfExists('parentConfirmTimeEnd', $data ?? [], null);
        $this->setIfExists('regionId', $data ?? [], null);
        $this->setIfExists('fulfillmentTypeList', $data ?? [], null);
        $this->setIfExists('parentOrderLabel', $data ?? [], null);
        $this->setIfExists('packageAbnormalTypeList', $data ?? [], null);
        $this->setIfExists('sortby', $data ?? [], null);
        $this->setIfExists('hasPreSaleOrder', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties(): array
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid(): bool
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType(): ?string
    {
        return $this->container['type'] ?? null;
    }

    /**
     * Sets type
     *
     * @param string $type
     * @return self
     */
    public function setType(string $type): self
    {
        $this->container['type'] = $type;
        return $this;
    }

    /**
     * Get page number
     *
     * @return int|null
     */
    public function getPageNumber(): ?int
    {
        return $this->container['pageNumber'] ?? null;
    }

    /**
     * Set page number
     * Page number for pagination, default is 1.
     *
     * @param int|null $pageNumber
     * @return self
     */
    public function setPageNumber(?int $pageNumber): self
    {
        $this->container['pageNumber'] = $pageNumber;
        return $this;
    }

    /**
     * Get page size
     *
     * @return int|null
     */
    public function getPageSize(): ?int
    {
        return $this->container['pageSize'] ?? null;
    }

    /**
     * Set page size
     * Page size for pagination, default is 10, max is 100.
     *
     * @param int|null $pageSize
     * @return self
     */
    public function setPageSize(?int $pageSize): self
    {
        $this->container['pageSize'] = $pageSize;
        return $this;
    }

    /**
     * Get parent order status
     *
     * @return int|null
     */
    public function getParentOrderStatus(): ?int
    {
        return $this->container['parentOrderStatus'] ?? null;
    }

    /**
     * Set parent order status
     * Parent order status, default is to query all.
     * Enum values: 0:All, 1:PENDING, 2:UN_SHIPPING, 3:CANCELED, 4:SHIPPED, 5:RECEIPTED, 41:Partially shipped, 51:Partially received
     *
     * @param int|null $parentOrderStatus
     * @return self
     */
    public function setParentOrderStatus(?int $parentOrderStatus): self
    {
        $this->container['parentOrderStatus'] = $parentOrderStatus;
        return $this;
    }

    /**
     * Get parent order SN list
     *
     * @return string[]|null
     */
    public function getParentOrderSnList(): ?array
    {
        return $this->container['parentOrderSnList'] ?? null;
    }

    /**
     * Set parent order SN list
     * List of parent order numbers, max 20 per request.
     *
     * @param string[]|null $parentOrderSnList
     * @return self
     */
    public function setParentOrderSnList(?array $parentOrderSnList): self
    {
        $this->container['parentOrderSnList'] = $parentOrderSnList;
        return $this;
    }

    /**
     * Get create after timestamp
     *
     * @return int|null
     */
    public function getCreateAfter(): ?int
    {
        return $this->container['createAfter'] ?? null;
    }

    /**
     * Set create after timestamp
     * Start time for querying parent order creation, in seconds (timestamp).
     * Must be used in conjunction with createBefore.
     *
     * @param int|null $createAfter
     * @return self
     */
    public function setCreateAfter(?int $createAfter): self
    {
        $this->container['createAfter'] = $createAfter;
        return $this;
    }

    /**
     * Get create before timestamp
     *
     * @return int|null
     */
    public function getCreateBefore(): ?int
    {
        return $this->container['createBefore'] ?? null;
    }

    /**
     * Set create before timestamp
     * End time for querying parent order creation, in seconds (timestamp).
     * Must be used in conjunction with createAfter.
     *
     * @param int|null $createBefore
     * @return self
     */
    public function setCreateBefore(?int $createBefore): self
    {
        $this->container['createBefore'] = $createBefore;
        return $this;
    }

    /**
     * Get expected ship latest time start
     *
     * @return int|null
     */
    public function getExpectShipLatestTimeStart(): ?int
    {
        return $this->container['expectShipLatestTimeStart'] ?? null;
    }

    /**
     * Set expected ship latest time start
     * Start time for querying expected latest shipment, in seconds.
     *
     * @param int|null $expectShipLatestTimeStart
     * @return self
     */
    public function setExpectShipLatestTimeStart(?int $expectShipLatestTimeStart): self
    {
        $this->container['expectShipLatestTimeStart'] = $expectShipLatestTimeStart;
        return $this;
    }

    /**
     * Get expected ship latest time end
     *
     * @return int|null
     */
    public function getExpectShipLatestTimeEnd(): ?int
    {
        return $this->container['expectShipLatestTimeEnd'] ?? null;
    }

    /**
     * Set expected ship latest time end
     * End time for querying expected latest shipment, in seconds.
     *
     * @param int|null $expectShipLatestTimeEnd
     * @return self
     */
    public function setExpectShipLatestTimeEnd(?int $expectShipLatestTimeEnd): self
    {
        $this->container['expectShipLatestTimeEnd'] = $expectShipLatestTimeEnd;
        return $this;
    }

    /**
     * Get update at start timestamp
     *
     * @return int|null
     */
    public function getUpdateAtStart(): ?int
    {
        return $this->container['updateAtStart'] ?? null;
    }

    /**
     * Set update at start timestamp
     * Start time for querying order update, in seconds (timestamp).
     * Must be used in conjunction with updateAtEnd.
     *
     * @param int|null $updateAtStart
     * @return self
     */
    public function setUpdateAtStart(?int $updateAtStart): self
    {
        $this->container['updateAtStart'] = $updateAtStart;
        return $this;
    }

    /**
     * Get update at end timestamp
     *
     * @return int|null
     */
    public function getUpdateAtEnd(): ?int
    {
        return $this->container['updateAtEnd'] ?? null;
    }

    /**
     * Set update at end timestamp
     * End time for querying order update, in seconds (timestamp).
     * Must be used in conjunction with updateAtStart.
     *
     * @param int|null $updateAtEnd
     * @return self
     */
    public function setUpdateAtEnd(?int $updateAtEnd): self
    {
        $this->container['updateAtEnd'] = $updateAtEnd;
        return $this;
    }

    /**
     * Get parent confirm time start
     *
     * @return int|null
     */
    public function getParentConfirmTimeStart(): ?int
    {
        return $this->container['parentConfirmTimeStart'] ?? null;
    }

    /**
     * Set parent confirm time start
     * Query the confirmed start time of the parent order, in seconds (timestamp).
     * Must be used together with parentConfirmTimeEnd.
     *
     * @param int|null $parentConfirmTimeStart
     * @return self
     */
    public function setParentConfirmTimeStart(?int $parentConfirmTimeStart): self
    {
        $this->container['parentConfirmTimeStart'] = $parentConfirmTimeStart;
        return $this;
    }

    /**
     * Get parent confirm time end
     *
     * @return int|null
     */
    public function getParentConfirmTimeEnd(): ?int
    {
        return $this->container['parentConfirmTimeEnd'] ?? null;
    }

    /**
     * Set parent confirm time end
     * Query the confirmation end time of the parent order in seconds (timestamp).
     * Must be used together with parentConfirmTimeStart.
     *
     * @param int|null $parentConfirmTimeEnd
     * @return self
     */
    public function setParentConfirmTimeEnd(?int $parentConfirmTimeEnd): self
    {
        $this->container['parentConfirmTimeEnd'] = $parentConfirmTimeEnd;
        return $this;
    }

    /**
     * Get region ID
     *
     * @return int|null
     */
    public function getRegionId(): ?int
    {
        return $this->container['regionId'] ?? null;
    }

    /**
     * Set region ID
     * Region ID, e.g., USA - 211.
     *
     * @param int|null $regionId
     * @return self
     */
    public function setRegionId(?int $regionId): self
    {
        $this->container['regionId'] = $regionId;
        return $this;
    }

    /**
     * Get fulfillment type list
     *
     * @return string[]|null
     */
    public function getFulfillmentTypeList(): ?array
    {
        return $this->container['fulfillmentTypeList'] ?? null;
    }

    /**
     * Set fulfillment type list
     * The type of order fulfillment.
     * Enum values: fulfillBySeller, fulfillByCooperativeWarehouse
     *
     * @param string[]|null $fulfillmentTypeList
     * @return self
     */
    public function setFulfillmentTypeList(?array $fulfillmentTypeList): self
    {
        $this->container['fulfillmentTypeList'] = $fulfillmentTypeList;
        return $this;
    }

    /**
     * Get parent order label
     *
     * @return string[]|null
     */
    public function getParentOrderLabel(): ?array
    {
        return $this->container['parentOrderLabel'] ?? null;
    }

    /**
     * Set parent order label
     * List of PO order status labels: soon_to_be_overdue, past_due, pending_buyer_cancellation,
     * pending_buyer_address_change, pending_risk_control_alert, signature_required_on_delivery
     *
     * @param string[]|null $parentOrderLabel
     * @return self
     */
    public function setParentOrderLabel(?array $parentOrderLabel): self
    {
        $this->container['parentOrderLabel'] = $parentOrderLabel;
        return $this;
    }

    /**
     * Get package abnormal type list
     *
     * @return string[]|null
     */
    public function getPackageAbnormalTypeList(): ?array
    {
        return $this->container['packageAbnormalTypeList'] ?? null;
    }

    /**
     * Set package abnormal type list
     * Logistics anomalies after order is shipped: WRONG_SHIPPING_ADDRESS, SUSPECTED_ERROR_PROVIDER,
     * NO_TRACK, TRACK_TOO_EARLY, OVERTIME_COLLECTION, TRACK_COLLECT_FAIL
     *
     * @param string[]|null $packageAbnormalTypeList
     * @return self
     */
    public function setPackageAbnormalTypeList(?array $packageAbnormalTypeList): self
    {
        $this->container['packageAbnormalTypeList'] = $packageAbnormalTypeList;
        return $this;
    }

    /**
     * Get sort by
     *
     * @return string|null
     */
    public function getSortby(): ?string
    {
        return $this->container['sortby'] ?? null;
    }

    /**
     * Set sort by
     * Sort by, output in reverse order. By default, the order creation time is used.
     * The corresponding enumeration is: updateTime, createTime.
     *
     * @param string|null $sortby
     * @return self
     */
    public function setSortby(?string $sortby): self
    {
        $this->container['sortby'] = $sortby;
        return $this;
    }

    /**
     * Get has pre-sale order
     *
     * @return bool|null
     */
    public function getHasPreSaleOrder(): ?bool
    {
        return $this->container['hasPreSaleOrder'] ?? null;
    }

    /**
     * Set has pre-sale order
     * Whether the parent order contains presale orders for inventory in transit.
     *
     * @param bool|null $hasPreSaleOrder
     * @return self
     */
    public function setHasPreSaleOrder(?bool $hasPreSaleOrder): self
    {
        $this->container['hasPreSaleOrder'] = $hasPreSaleOrder;
        return $this;
    }

    /**
     * Get the response class for this request
     *
     * @return string
     */
    public function getResponseClass(): string
    {
        return $this->responseClass;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize(): mixed
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue(): string
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


