<?php
/**
 * OrderItem
 * PHP version 8.1
 */

namespace Temu\Model;

use ArrayAccess;
use Temu\ObjectSerializer;

class OrderItem implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;
    protected static string $openAPIModelName = 'OrderItem';

    protected static array $openAPITypes = [
        'orderSn' => 'string',
        'quantity' => 'int',
        'canceledQuantityBeforeShipment' => 'int',
        'originalOrderQuantity' => 'int',
        'goodsId' => 'int',
        'skuId' => 'int',
        'spec' => 'string',
        'originalSpecName' => 'string',
        'thumbUrl' => 'string',
        'goodsName' => 'string',
        'originalGoodsName' => 'string',
        'orderStatus' => 'int',
        'productList' => '\Temu\Model\ProductItem[]',
        'packageAbnormalTypeList' => 'string[]',
        'orderLabel' => '\Temu\Model\OrderLabel[]',
        'fulfillmentWarning' => 'string[]',
        'fulfillmentType' => 'string',
        'inventoryDeductionWarehouseId' => 'string',
        'inventoryDeductionWarehouseName' => 'string',
        'orderPaymentType' => 'string',
        'isCancelledDuringPending' => 'bool',
        'orderShippingTime' => 'int',
        'orderCreateTime' => 'int',
        'earliestTimeGetShippingDocument' => 'int',
        'packageSnInfo' => 'array',
    ];

    protected array $container = [];

    public function __construct(?array $data = null)
    {
        $this->container['orderSn'] = $data['orderSn'] ?? null;
        $this->container['quantity'] = $data['quantity'] ?? null;
        $this->container['canceledQuantityBeforeShipment'] = $data['canceledQuantityBeforeShipment'] ?? null;
        $this->container['originalOrderQuantity'] = $data['originalOrderQuantity'] ?? null;
        $this->container['goodsId'] = $data['goodsId'] ?? null;
        $this->container['skuId'] = $data['skuId'] ?? null;
        $this->container['spec'] = $data['spec'] ?? null;
        $this->container['originalSpecName'] = $data['originalSpecName'] ?? null;
        $this->container['thumbUrl'] = $data['thumbUrl'] ?? null;
        $this->container['goodsName'] = $data['goodsName'] ?? null;
        $this->container['originalGoodsName'] = $data['originalGoodsName'] ?? null;
        $this->container['orderStatus'] = $data['orderStatus'] ?? null;
        $this->container['packageAbnormalTypeList'] = $data['packageAbnormalTypeList'] ?? null;
        $this->container['fulfillmentWarning'] = $data['fulfillmentWarning'] ?? null;
        $this->container['fulfillmentType'] = $data['fulfillmentType'] ?? null;
        $this->container['inventoryDeductionWarehouseId'] = $data['inventoryDeductionWarehouseId'] ?? null;
        $this->container['inventoryDeductionWarehouseName'] = $data['inventoryDeductionWarehouseName'] ?? null;
        $this->container['orderPaymentType'] = $data['orderPaymentType'] ?? null;
        $this->container['isCancelledDuringPending'] = $data['isCancelledDuringPending'] ?? null;
        $this->container['orderShippingTime'] = $data['orderShippingTime'] ?? null;
        $this->container['orderCreateTime'] = $data['orderCreateTime'] ?? null;
        $this->container['earliestTimeGetShippingDocument'] = $data['earliestTimeGetShippingDocument'] ?? null;
        $this->container['packageSnInfo'] = $data['packageSnInfo'] ?? null;

        // Handle productList array of ProductItem objects
        if (isset($data['productList']) && is_array($data['productList'])) {
            $this->container['productList'] = array_map(
                fn($item) => $item instanceof ProductItem ? $item : new ProductItem(is_array($item) ? $item : (array)$item),
                $data['productList']
            );
        } else {
            $this->container['productList'] = null;
        }

        // Handle orderLabel array of OrderLabel objects
        if (isset($data['orderLabel']) && is_array($data['orderLabel'])) {
            $this->container['orderLabel'] = array_map(
                fn($item) => $item instanceof OrderLabel ? $item : new OrderLabel(is_array($item) ? $item : (array)$item),
                $data['orderLabel']
            );
        } else {
            $this->container['orderLabel'] = null;
        }
    }

    public static function openAPITypes(): array { return self::$openAPITypes; }
    public static function openAPIFormats(): array { return []; }
    public static function attributeMap(): array { return []; }
    public static function setters(): array { return []; }
    public static function getters(): array { return []; }
    public static function isNullable(string $property): bool { return false; }
    public function isNullableSetToNull(string $property): bool { return false; }
    public function getModelName(): string { return self::$openAPIModelName; }
    public function listInvalidProperties(): array { return []; }
    public function valid(): bool { return true; }

    public function offsetExists($offset): bool { return isset($this->container[$offset]); }
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) { return $this->container[$offset] ?? null; }
    public function offsetSet($offset, $value): void { $this->container[is_null($offset) ? count($this->container) : $offset] = $value; }
    public function offsetUnset($offset): void { unset($this->container[$offset]); }

    #[\ReturnTypeWillChange]
    public function jsonSerialize(): mixed { return ObjectSerializer::sanitizeForSerialization($this); }
    public function __toString(): string { return json_encode($this->jsonSerialize(), JSON_PRETTY_PRINT); }
}
