<?php
/**
 * OrderDetailResult
 * PHP version 8.1
 */

namespace Temu\Model;

use ArrayAccess;
use Temu\ObjectSerializer;

/**
 * OrderDetailResult Class - Result for order detail response
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class OrderDetailResult implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'OrderDetailResult';

    protected static array $openAPITypes = [
        'parentOrderMap' => 'array',
        'orderList' => 'array'
    ];

    protected static array $openAPIFormats = [
        'parentOrderMap' => null,
        'orderList' => null
    ];

    protected static array $openAPINullables = [
        'parentOrderMap' => true,
        'orderList' => true
    ];

    protected array $openAPINullablesSetToNull = [];

    protected static array $attributeMap = [
        'parentOrderMap' => 'parentOrderMap',
        'orderList' => 'orderList'
    ];

    protected static array $setters = [
        'parentOrderMap' => 'setParentOrderMap',
        'orderList' => 'setOrderList'
    ];

    protected static array $getters = [
        'parentOrderMap' => 'getParentOrderMap',
        'orderList' => 'getOrderList'
    ];

    protected array $container = [];

    public function __construct(?array $data = null)
    {
        // Recursively convert all stdClass objects to arrays
        $this->container['parentOrderMap'] = isset($data['parentOrderMap'])
            ? json_decode(json_encode($data['parentOrderMap']), true)
            : null;
        $this->container['orderList'] = isset($data['orderList'])
            ? json_decode(json_encode($data['orderList']), true)
            : null;
    }

    public static function openAPITypes(): array { return self::$openAPITypes; }
    public static function openAPIFormats(): array { return self::$openAPIFormats; }
    protected static function openAPINullables(): array { return self::$openAPINullables; }
    private function getOpenAPINullablesSetToNull(): array { return $this->openAPINullablesSetToNull; }
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void { $this->openAPINullablesSetToNull = $openAPINullablesSetToNull; }
    public static function isNullable(string $property): bool { return self::openAPINullables()[$property] ?? false; }
    public function isNullableSetToNull(string $property): bool { return in_array($property, $this->getOpenAPINullablesSetToNull(), true); }
    public static function attributeMap(): array { return self::$attributeMap; }
    public static function setters(): array { return self::$setters; }
    public static function getters(): array { return self::$getters; }
    public function getModelName(): string { return self::$openAPIModelName; }
    public function listInvalidProperties(): array { return []; }
    public function valid(): bool { return count($this->listInvalidProperties()) === 0; }

    /**
     * Gets parentOrderMap
     *
     * @return array|null
     */
    public function getParentOrderMap(): ?array
    {
        return $this->container['parentOrderMap'] ?? null;
    }

    /**
     * Sets parentOrderMap
     *
     * @param array|null $parentOrderMap Parent order information map
     * @return self
     */
    public function setParentOrderMap(?array $parentOrderMap): self
    {
        // Convert stdClass to arrays recursively
        $this->container['parentOrderMap'] = $parentOrderMap !== null
            ? json_decode(json_encode($parentOrderMap), true)
            : null;
        return $this;
    }

    /**
     * Gets orderList
     *
     * @return array|null
     */
    public function getOrderList(): ?array
    {
        return $this->container['orderList'] ?? null;
    }

    /**
     * Sets orderList
     *
     * @param array|null $orderList List of order items
     * @return self
     */
    public function setOrderList(?array $orderList): self
    {
        // Convert stdClass to arrays recursively
        $this->container['orderList'] = $orderList !== null
            ? json_decode(json_encode($orderList), true)
            : null;
        return $this;
    }

    public function offsetExists($offset): bool { return isset($this->container[$offset]); }
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) { return $this->container[$offset] ?? null; }
    public function offsetSet($offset, $value): void {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }
    public function offsetUnset($offset): void { unset($this->container[$offset]); }

    #[\ReturnTypeWillChange]
    public function jsonSerialize(): mixed { return ObjectSerializer::sanitizeForSerialization($this); }
    public function __toString(): string { return json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT); }
    public function toHeaderValue(): string { return json_encode(ObjectSerializer::sanitizeForSerialization($this)); }
}
