<?php
/**
 * OrderDetailResponse
 * PHP version 8.1
 */

namespace Temu\Model;

use ArrayAccess;
use Temu\ObjectSerializer;

/**
 * OrderDetailResponse Class - Response for OrderDetail API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class OrderDetailResponse implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'OrderDetailResponse';

    protected static array $openAPITypes = [
        'success' => 'bool',
        'requestId' => 'string',
        'errorCode' => 'int',
        'errorMsg' => 'string',
        'result' => '\Temu\Model\OrderDetailResult'
    ];

    protected static array $openAPIFormats = [
        'success' => null,
        'requestId' => null,
        'errorCode' => 'int32',
        'errorMsg' => null,
        'result' => null
    ];

    protected static array $openAPINullables = [
        'success' => false,
        'requestId' => true,
        'errorCode' => false,
        'errorMsg' => true,
        'result' => false
    ];

    protected array $openAPINullablesSetToNull = [];

    protected static array $attributeMap = [
        'success' => 'success',
        'requestId' => 'requestId',
        'errorCode' => 'errorCode',
        'errorMsg' => 'errorMsg',
        'result' => 'result'
    ];

    protected static array $setters = [
        'success' => 'setSuccess',
        'requestId' => 'setRequestId',
        'errorCode' => 'setErrorCode',
        'errorMsg' => 'setErrorMsg',
        'result' => 'setResult'
    ];

    protected static array $getters = [
        'success' => 'getSuccess',
        'requestId' => 'getRequestId',
        'errorCode' => 'getErrorCode',
        'errorMsg' => 'getErrorMsg',
        'result' => 'getResult'
    ];

    protected array $container = [];

    public function __construct(?array $data = null)
    {
        $this->container['success'] = $data['success'] ?? null;
        $this->container['requestId'] = $data['requestId'] ?? $data['request_id'] ?? null;
        $this->container['errorCode'] = $data['errorCode'] ?? $data['error_code'] ?? null;
        $this->container['errorMsg'] = $data['errorMsg'] ?? $data['error_msg'] ?? null;
        $this->container['result'] = isset($data['result']) && is_array($data['result']) ? new OrderDetailResult($data['result']) : null;
    }

    public static function openAPITypes(): array { return self::$openAPITypes; }
    public static function openAPIFormats(): array { return self::$openAPIFormats; }
    protected static function openAPINullables(): array { return self::$openAPINullables; }
    private function getOpenAPINullablesSetToNull(): array { return $this->openAPINullablesSetToNull; }
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void { $this->openAPINullablesSetToNull = $openAPINullablesSetToNull; }
    public static function isNullable(string $property): bool { return self::openAPINullables()[$property] ?? false; }
    public function isNullableSetToNull(string $property): bool { return in_array($property, $this->getOpenAPINullablesSetToNull(), true); }
    public static function attributeMap(): array { return self::$attributeMap; }
    public static function setters(): array { return self::$setters; }
    public static function getters(): array { return self::$getters; }
    public function getModelName(): string { return self::$openAPIModelName; }
    public function listInvalidProperties(): array { return []; }
    public function valid(): bool { return count($this->listInvalidProperties()) === 0; }

    /**
     * Gets success
     *
     * @return bool|null
     */
    public function getSuccess(): ?bool
    {
        return $this->container['success'] ?? null;
    }

    /**
     * Sets success
     *
     * @param bool|null $success Success status
     * @return self
     */
    public function setSuccess(?bool $success): self
    {
        $this->container['success'] = $success;
        return $this;
    }

    /**
     * Gets requestId
     *
     * @return string|null
     */
    public function getRequestId(): ?string
    {
        return $this->container['requestId'] ?? null;
    }

    /**
     * Sets requestId
     *
     * @param string|null $requestId Request ID
     * @return self
     */
    public function setRequestId(?string $requestId): self
    {
        $this->container['requestId'] = $requestId;
        return $this;
    }

    /**
     * Gets errorCode
     *
     * @return int|null
     */
    public function getErrorCode(): ?int
    {
        return $this->container['errorCode'] ?? null;
    }

    /**
     * Sets errorCode
     *
     * @param int|null $errorCode Error code
     * @return self
     */
    public function setErrorCode(?int $errorCode): self
    {
        $this->container['errorCode'] = $errorCode;
        return $this;
    }

    /**
     * Gets errorMsg
     *
     * @return string|null
     */
    public function getErrorMsg(): ?string
    {
        return $this->container['errorMsg'] ?? null;
    }

    /**
     * Sets errorMsg
     *
     * @param string|null $errorMsg Error message
     * @return self
     */
    public function setErrorMsg(?string $errorMsg): self
    {
        $this->container['errorMsg'] = $errorMsg;
        return $this;
    }

    /**
     * Gets result
     *
     * @return \Temu\Model\OrderDetailResult|null
     */
    public function getResult(): ?OrderDetailResult
    {
        return $this->container['result'] ?? null;
    }

    /**
     * Sets result
     *
     * @param \Temu\Model\OrderDetailResult|null $result Result data
     * @return self
     */
    public function setResult(?OrderDetailResult $result): self
    {
        $this->container['result'] = $result;
        return $this;
    }

    public function offsetExists($offset): bool { return isset($this->container[$offset]); }
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) { return $this->container[$offset] ?? null; }
    public function offsetSet($offset, $value): void {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }
    public function offsetUnset($offset): void { unset($this->container[$offset]); }

    #[\ReturnTypeWillChange]
    public function jsonSerialize(): mixed { return ObjectSerializer::sanitizeForSerialization($this); }
    public function __toString(): string { return json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT); }
    public function toHeaderValue(): string { return json_encode(ObjectSerializer::sanitizeForSerialization($this)); }
}
