<?php
/**
 * OrderDetailRequest
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Temu Open APIs
 *
 * Comprehensive API collection for Temu marketplace operations including product management, order processing, inventory management, pricing, and fulfillment services.  All endpoints use POST method with operation type specified in request body. Authentication uses MD5 signature with app_key, app_secret, access_token, and timestamp.
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.1.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Temu\Model;

use \ArrayAccess;
use \Temu\ObjectSerializer;

/**
 * OrderDetailRequest Class - Request model for getOrderDetail API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class OrderDetailRequest extends BaseRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'OrderDetailRequest';

    protected static array $openAPITypes = [
        'type' => 'string',
        'parentOrderSn' => 'string',
        'fulfillmentTypeList' => 'string[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static array $openAPIFormats = [
        'type' => null,
        'parentOrderSn' => null,
        'fulfillmentTypeList' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'type' => false,
        'parentOrderSn' => false,
        'fulfillmentTypeList' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats(): array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'type' => 'type',
        'parentOrderSn' => 'parentOrderSn',
        'fulfillmentTypeList' => 'fulfillmentTypeList'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static array $setters = [
        'type' => 'setType',
        'parentOrderSn' => 'setParentOrderSn',
        'fulfillmentTypeList' => 'setFulfillmentTypeList'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static array $getters = [
        'type' => 'getType',
        'parentOrderSn' => 'getParentOrderSn',
        'fulfillmentTypeList' => 'getFulfillmentTypeList'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap(): array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters(): array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters(): array
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName(): string
    {
        return self::$openAPIModelName;
    }

    /**
     * The response class for this request
     *
     * @var string
     */
    protected string $responseClass = OrderDetailResponse::class;

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(?array $data = null)
    {
        parent::__construct();
        $this->setIfExists('type', $data ?? [], 'bg.order.detail.v2.get');
        $this->setIfExists('parentOrderSn', $data ?? [], null);
        $this->setIfExists('fulfillmentTypeList', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties(): array
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid(): bool
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType(): ?string
    {
        return $this->container['type'] ?? null;
    }

    /**
     * Sets type
     *
     * @param string $type
     * @return self
     */
    public function setType(string $type): self
    {
        $this->container['type'] = $type;
        return $this;
    }

    /**
     * Get parent order SN
     *
     * @return string|null
     */
    public function getParentOrderSn(): ?string
    {
        return $this->container['parentOrderSn'] ?? null;
    }

    /**
     * Set parent order SN
     * Parent order number (Required)
     *
     * @param string|null $parentOrderSn
     * @return self
     */
    public function setParentOrderSn(?string $parentOrderSn): self
    {
        $this->container['parentOrderSn'] = $parentOrderSn;
        return $this;
    }

    /**
     * Get fulfillment type list
     *
     * @return string[]|null
     */
    public function getFulfillmentTypeList(): ?array
    {
        return $this->container['fulfillmentTypeList'] ?? null;
    }

    /**
     * Set fulfillment type list
     * The type of order fulfillment.
     * Enum values: fulfillBySeller, fulfillByCooperativeWarehouse
     *
     * @param string[]|null $fulfillmentTypeList
     * @return self
     */
    public function setFulfillmentTypeList(?array $fulfillmentTypeList): self
    {
        $this->container['fulfillmentTypeList'] = $fulfillmentTypeList;
        return $this;
    }

    /**
     * Get the response class for this request
     *
     * @return string
     */
    public function getResponseClass(): string
    {
        return $this->responseClass;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize(): mixed
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue(): string
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


