<?php
/**
 * NegotiateGoodsPriceOrderRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;

/**
 * NegotiateGoodsPriceOrderRequest Class - Request model for negotiateGoodsPriceOrder API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class NegotiateGoodsPriceOrderRequest extends BaseRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'NegotiateGoodsPriceOrderRequest';

    protected static array $openAPITypes = [
        'type' => 'string',
        'priceOrderId' => 'string',
        'goodsId' => 'int',
        'priceCommitVersion' => 'int',
        'priceCommitId' => 'string',
        'negotiatedPriceSkuList' => 'array'
    ];

    protected string $responseClass = NegotiateGoodsPriceOrderResponse::class;

    public function __construct(string $priceOrderId, int $goodsId, int $priceCommitVersion, string $priceCommitId, array $negotiatedPriceSkuList)
    {
        parent::__construct();
        $this->setType('bg.local.goods.priceorder.negotiate');
        $this->setPriceOrderId($priceOrderId);
        $this->setGoodsId($goodsId);
        $this->setPriceCommitVersion($priceCommitVersion);
        $this->setPriceCommitId($priceCommitId);
        $this->setNegotiatedPriceSkuList($negotiatedPriceSkuList);
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    public function getPriceOrderId(): ?string
    {
        return $this->container['priceOrderId'] ?? null;
    }

    public function setPriceOrderId(string $priceOrderId): self
    {
        $this->container['priceOrderId'] = $priceOrderId;
        return $this;
    }

    public function getGoodsId(): ?int
    {
        return $this->container['goodsId'] ?? null;
    }

    public function setGoodsId(int $goodsId): self
    {
        $this->container['goodsId'] = $goodsId;
        return $this;
    }

    public function getPriceCommitVersion(): ?int
    {
        return $this->container['priceCommitVersion'] ?? null;
    }

    public function setPriceCommitVersion(int $priceCommitVersion): self
    {
        $this->container['priceCommitVersion'] = $priceCommitVersion;
        return $this;
    }

    public function getPriceCommitId(): ?string
    {
        return $this->container['priceCommitId'] ?? null;
    }

    public function setPriceCommitId(string $priceCommitId): self
    {
        $this->container['priceCommitId'] = $priceCommitId;
        return $this;
    }

    public function getNegotiatedPriceSkuList(): ?array
    {
        return $this->container['negotiatedPriceSkuList'] ?? null;
    }

    public function setNegotiatedPriceSkuList(array $negotiatedPriceSkuList): self
    {
        $this->container['negotiatedPriceSkuList'] = $negotiatedPriceSkuList;
        return $this;
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }
}
