<?php
/**
 * GoodsTemplateRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

/**
 * GoodsTemplateRequest Class - Request for GetGoodsTemplate API
 *
 * @category Class
 * @package  Temu
 */
class GoodsTemplateRequest extends BaseRequest
{
    protected string $responseClass = GoodsTemplateResponse::class;

    protected static $openAPITypes = [
        'cat_id' => 'int'
    ];

    protected static $attributeMap = [
        'cat_id' => 'catId'
    ];

    public function __construct(int $catId)
    {
        parent::__construct();
        $this->setType('bg.local.goods.template.get');
        $this->setCatId($catId);
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }

    public function getCatId(): int
    {
        return $this->container['cat_id'];
    }

    public function setCatId(int $catId): self
    {
        $this->container['cat_id'] = $catId;
        return $this;
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes + parent::openAPITypes();
    }

    public static function attributeMap(): array
    {
        return self::$attributeMap + parent::attributeMap();
    }
}
