<?php
/**
 * GoodsSpecDetailRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;

/**
 * GoodsSpecDetailRequest Class - Request model for getGoodsSpecDetail API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class GoodsSpecDetailRequest extends BaseRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'GoodsSpecDetailRequest';

    protected static array $openAPITypes = [
        'type' => 'string',
        'specIdList' => 'array'
    ];

    protected string $responseClass = GoodsSpecDetailResponse::class;

    public function __construct(array $specIdList)
    {
        parent::__construct();
        $this->setType('temu.local.goods.spec.info.get');
        $this->setSpecIdList($specIdList);
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    public function getSpecIdList(): ?array
    {
        return $this->container['specIdList'] ?? null;
    }

    public function setSpecIdList(array $specIdList): self
    {
        $this->container['specIdList'] = $specIdList;
        return $this;
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }
}
