<?php
/**
 * GoodsSkuListResponse
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;
use Temu\ObjectSerializer;

/**
 * GoodsSkuListResponse Class - Response for getGoodsSkuList API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class GoodsSkuListResponse implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'GoodsSkuListResponse';

    protected static array $openAPITypes = [
        'success' => 'bool',
        'errorCode' => 'int',
        'errorMsg' => 'string',
        'requestId' => 'string',
        'result' => '\Temu\Model\GoodsSkuListResult'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static array $openAPIFormats = [
        'success' => null,
        'errorCode' => null,
        'errorMsg' => null,
        'requestId' => null,
        'result' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'success' => false,
        'errorCode' => true,
        'errorMsg' => true,
        'requestId' => true,
        'result' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats(): array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'success' => 'success',
        'errorCode' => 'errorCode',
        'errorMsg' => 'errorMsg',
        'requestId' => 'requestId',
        'result' => 'result'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static array $setters = [
        'success' => 'setSuccess',
        'errorCode' => 'setErrorCode',
        'errorMsg' => 'setErrorMsg',
        'requestId' => 'setRequestId',
        'result' => 'setResult'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static array $getters = [
        'success' => 'getSuccess',
        'errorCode' => 'getErrorCode',
        'errorMsg' => 'getErrorMsg',
        'requestId' => 'getRequestId',
        'result' => 'getResult'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap(): array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters(): array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters(): array
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName(): string
    {
        return self::$openAPIModelName;
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('success', $data ?? [], null);
        $this->setIfExists('errorCode', $data ?? [], null);
        $this->setIfExists('errorMsg', $data ?? [], null);
        $this->setIfExists('requestId', $data ?? [], null);
        $this->setIfExists('result', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties(): array
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid(): bool
    {
        return count($this->listInvalidProperties()) === 0;
    }

    public function getSuccess(): ?bool
    {
        return $this->container['success'];
    }

    public function setSuccess(?bool $success): self
    {
        $this->container['success'] = $success;
        return $this;
    }

    public function getErrorCode(): ?int
    {
        return $this->container['errorCode'];
    }

    public function setErrorCode(?int $errorCode): self
    {
        $this->container['errorCode'] = $errorCode;
        return $this;
    }

    public function getErrorMsg(): ?string
    {
        return $this->container['errorMsg'];
    }

    public function setErrorMsg(?string $errorMsg): self
    {
        $this->container['errorMsg'] = $errorMsg;
        return $this;
    }

    public function getRequestId(): ?string
    {
        return $this->container['requestId'];
    }

    public function setRequestId(?string $requestId): self
    {
        $this->container['requestId'] = $requestId;
        return $this;
    }

    public function getResult(): ?GoodsSkuListResult
    {
        return $this->container['result'];
    }

    public function setResult(?GoodsSkuListResult $result): self
    {
        $this->container['result'] = $result;
        return $this;
    }

    /**
     * Get page number from result
     *
     * @return int|null
     */
    public function getPageNo(): ?int
    {
        return $this->container['result']?->getPageNo();
    }

    /**
     * Get total count from result
     *
     * @return int|null
     */
    public function getTotal(): ?int
    {
        return $this->container['result']?->getTotal();
    }

    /**
     * Get SKU list from result
     *
     * @return GoodsSku[]|null Array of GoodsSku objects
     */
    public function getSkuList(): ?array
    {
        return $this->container['result']?->getSkuList();
    }

    /**
     * Get a specific SKU item by index
     *
     * @param int $index
     * @return GoodsSku|null
     */
    public function getSkuItem(int $index): ?GoodsSku
    {
        return $this->container['result']?->getSkuItem($index);
    }

    /**
     * Find SKU item by SKU ID
     *
     * @param int $skuId
     * @return GoodsSku|null
     */
    public function findSkuBySkuId(int $skuId): ?GoodsSku
    {
        return $this->container['result']?->findSkuBySkuId($skuId);
    }

    /**
     * Find SKU item by goods ID
     *
     * @param int $goodsId
     * @return GoodsSku|null
     */
    public function findSkuByGoodsId(int $goodsId): ?GoodsSku
    {
        return $this->container['result']?->findSkuByGoodsId($goodsId);
    }

    /**
     * Find SKU item by SKU code
     *
     * @param string $skuSn
     * @return GoodsSku|null
     */
    public function findSkuBySkuSn(string $skuSn): ?GoodsSku
    {
        return $this->container['result']?->findSkuBySkuSn($skuSn);
    }

    /**
     * Find SKU item by goods name
     *
     * @param string $goodsName
     * @return GoodsSku|null
     */
    public function findSkuByGoodsName(string $goodsName): ?GoodsSku
    {
        return $this->container['result']?->findSkuByGoodsName($goodsName);
    }

    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    public function offsetGet($offset): mixed
    {
        return $this->container[$offset] ?? null;
    }

    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
