<?php
/**
 * GoodsSkuListRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;
use Temu\ObjectSerializer;

/**
 * GoodsSkuListRequest Class - Request model for getGoodsSkuList API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class GoodsSkuListRequest extends BaseRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'GoodsSkuListRequest';

    protected static array $openAPITypes = [
        'type' => 'string',
        'pageNo' => 'int',
        'pageSize' => 'int',
        'orderField' => 'string',
        'orderType' => 'int',
        'skuSearchType' => 'int',
        'searchText' => 'string',
        'statusFilterType' => 'int',
        'crtFrom' => 'int',
        'crtTo' => 'int',
        'skuIdList' => 'int[]',
        'catIdList' => 'int[]',
        'skuStatusFilterType' => 'int',
        'skuSubStatusFilterType' => 'int',
        'skuStatusChangeTimeFrom' => 'int',
        'skuStatusChangeTimeTo' => 'int',
        'goodsSearchTags' => 'int[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static array $openAPIFormats = [
        'type' => null,
        'pageNo' => null,
        'pageSize' => null,
        'orderField' => null,
        'orderType' => null,
        'skuSearchType' => null,
        'searchText' => null,
        'statusFilterType' => null,
        'crtFrom' => null,
        'crtTo' => null,
        'skuIdList' => null,
        'catIdList' => null,
        'skuStatusFilterType' => null,
        'skuSubStatusFilterType' => null,
        'skuStatusChangeTimeFrom' => null,
        'skuStatusChangeTimeTo' => null,
        'goodsSearchTags' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'type' => false,
        'pageNo' => false,
        'pageSize' => false,
        'orderField' => true,
        'orderType' => true,
        'skuSearchType' => false,
        'searchText' => true,
        'statusFilterType' => true,
        'crtFrom' => true,
        'crtTo' => true,
        'skuIdList' => true,
        'catIdList' => true,
        'skuStatusFilterType' => false,
        'skuSubStatusFilterType' => true,
        'skuStatusChangeTimeFrom' => true,
        'skuStatusChangeTimeTo' => true,
        'goodsSearchTags' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats(): array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'type' => 'type',
        'pageNo' => 'pageNo',
        'pageSize' => 'pageSize',
        'orderField' => 'orderField',
        'orderType' => 'orderType',
        'skuSearchType' => 'skuSearchType',
        'searchText' => 'searchText',
        'statusFilterType' => 'statusFilterType',
        'crtFrom' => 'crtFrom',
        'crtTo' => 'crtTo',
        'skuIdList' => 'skuIdList',
        'catIdList' => 'catIdList',
        'skuStatusFilterType' => 'skuStatusFilterType',
        'skuSubStatusFilterType' => 'skuSubStatusFilterType',
        'skuStatusChangeTimeFrom' => 'skuStatusChangeTimeFrom',
        'skuStatusChangeTimeTo' => 'skuStatusChangeTimeTo',
        'goodsSearchTags' => 'goodsSearchTags'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static array $setters = [
        'type' => 'setType',
        'pageNo' => 'setPageNo',
        'pageSize' => 'setPageSize',
        'orderField' => 'setOrderField',
        'orderType' => 'setOrderType',
        'skuSearchType' => 'setSkuSearchType',
        'searchText' => 'setSearchText',
        'statusFilterType' => 'setStatusFilterType',
        'crtFrom' => 'setCrtFrom',
        'crtTo' => 'setCrtTo',
        'skuIdList' => 'setSkuIdList',
        'catIdList' => 'setCatIdList',
        'skuStatusFilterType' => 'setSkuStatusFilterType',
        'skuSubStatusFilterType' => 'setSkuSubStatusFilterType',
        'skuStatusChangeTimeFrom' => 'setSkuStatusChangeTimeFrom',
        'skuStatusChangeTimeTo' => 'setSkuStatusChangeTimeTo',
        'goodsSearchTags' => 'setGoodsSearchTags'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static array $getters = [
        'type' => 'getType',
        'pageNo' => 'getPageNo',
        'pageSize' => 'getPageSize',
        'orderField' => 'getOrderField',
        'orderType' => 'getOrderType',
        'skuSearchType' => 'getSkuSearchType',
        'searchText' => 'getSearchText',
        'statusFilterType' => 'getStatusFilterType',
        'crtFrom' => 'getCrtFrom',
        'crtTo' => 'getCrtTo',
        'skuIdList' => 'getSkuIdList',
        'catIdList' => 'getCatIdList',
        'skuStatusFilterType' => 'getSkuStatusFilterType',
        'skuSubStatusFilterType' => 'getSkuSubStatusFilterType',
        'skuStatusChangeTimeFrom' => 'getSkuStatusChangeTimeFrom',
        'skuStatusChangeTimeTo' => 'getSkuStatusChangeTimeTo',
        'goodsSearchTags' => 'getGoodsSearchTags'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap(): array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters(): array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters(): array
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName(): string
    {
        return self::$openAPIModelName;
    }

    /**
     * The response class for this request
     *
     * @var string
     */
    protected string $responseClass = GoodsSkuListResponse::class;

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(?array $data = null)
    {
        parent::__construct();
        $this->setIfExists('type', $data ?? [], 'bg.local.goods.sku.list.query');
        $this->setIfExists('pageNo', $data ?? [], 1);
        $this->setIfExists('pageSize', $data ?? [], 25);
        $this->setIfExists('orderField', $data ?? [], null);
        $this->setIfExists('orderType', $data ?? [], null);
        $this->setIfExists('skuSearchType', $data ?? [], null);
        $this->setIfExists('searchText', $data ?? [], null);
        $this->setIfExists('statusFilterType', $data ?? [], null);
        $this->setIfExists('crtFrom', $data ?? [], null);
        $this->setIfExists('crtTo', $data ?? [], null);
        $this->setIfExists('skuIdList', $data ?? [], null);
        $this->setIfExists('catIdList', $data ?? [], null);
        $this->setIfExists('skuStatusFilterType', $data ?? [], 2);
        $this->setIfExists('skuSubStatusFilterType', $data ?? [], null);
        $this->setIfExists('skuStatusChangeTimeFrom', $data ?? [], null);
        $this->setIfExists('skuStatusChangeTimeTo', $data ?? [], null);
        $this->setIfExists('goodsSearchTags', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties(): array
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid(): bool
    {
        return count($this->listInvalidProperties()) === 0;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType(): ?string
    {
        return $this->container['type'] ?? null;
    }

    /**
     * Sets type
     *
     * @param string $type
     * @return self
     */
    public function setType(string $type): self
    {
        $this->container['type'] = $type;
        return $this;
    }

    /**
     * Get SKU status filter type
     *
     * @return int|null
     */
    public function getSkuStatusFilterType(): ?int
    {
        return $this->container['skuStatusFilterType'] ?? null;
    }

    /**
     * Set SKU status filter type
     *
     * @param int $skuStatusFilterType
     * @return self
     */
    public function setSkuStatusFilterType(int $skuStatusFilterType): self
    {
        $this->container['skuStatusFilterType'] = $skuStatusFilterType;
        return $this;
    }

    /**
     * Get page number
     *
     * @return int|null
     */
    public function getPageNo(): ?int
    {
        return $this->container['pageNo'] ?? null;
    }

    /**
     * Set page number
     *
     * @param int $pageNo
     * @return self
     */
    public function setPageNo(int $pageNo): self
    {
        $this->container['pageNo'] = $pageNo;
        return $this;
    }

    /**
     * Get page size
     *
     * @return int|null
     */
    public function getPageSize(): ?int
    {
        return $this->container['pageSize'] ?? null;
    }

    /**
     * Set page size
     *
     * @param int $pageSize
     * @return self
     */
    public function setPageSize(int $pageSize): self
    {
        $this->container['pageSize'] = $pageSize;
        return $this;
    }

    /**
     * Get order field
     *
     * @return string|null
     */
    public function getOrderField(): ?string
    {
        return $this->container['orderField'] ?? null;
    }

    /**
     * Set order field
     * Supports: goodsId, createTime, goodsName, outGoodsSn, quantity, price
     *
     * @param string|null $orderField
     * @return self
     */
    public function setOrderField(?string $orderField): self
    {
        $this->container['orderField'] = $orderField;
        return $this;
    }

    /**
     * Get order type
     *
     * @return int|null
     */
    public function getOrderType(): ?int
    {
        return $this->container['orderType'] ?? null;
    }

    /**
     * Set order type
     * 0 for descending order, 1 for ascending order
     *
     * @param int|null $orderType
     * @return self
     */
    public function setOrderType(?int $orderType): self
    {
        $this->container['orderType'] = $orderType;
        return $this;
    }

    /**
     * Get SKU search type
     *
     * @return int|null
     */
    public function getSkuSearchType(): ?int
    {
        return $this->container['skuSearchType'] ?? null;
    }

    /**
     * Set SKU search type (REQUIRED)
     * Product status: 2 - Available for sale, 3 - Not available for sale
     *
     * @param int $skuSearchType
     * @return self
     */
    public function setSkuSearchType(int $skuSearchType): self
    {
        $this->container['skuSearchType'] = $skuSearchType;
        return $this;
    }

    /**
     * Get search text
     *
     * @return string|null
     */
    public function getSearchText(): ?string
    {
        return $this->container['searchText'] ?? null;
    }

    /**
     * Set search text
     * Supports searching by goodsName, goodsId, or SKU code
     *
     * @param string|null $searchText
     * @return self
     */
    public function setSearchText(?string $searchText): self
    {
        $this->container['searchText'] = $searchText;
        return $this;
    }

    /**
     * Get status filter type
     *
     * @return int|null
     */
    public function getStatusFilterType(): ?int
    {
        return $this->container['statusFilterType'] ?? null;
    }

    /**
     * Set status filter type
     *
     * @param int|null $statusFilterType
     * @return self
     */
    public function setStatusFilterType(?int $statusFilterType): self
    {
        $this->container['statusFilterType'] = $statusFilterType;
        return $this;
    }

    /**
     * Get creation start time
     *
     * @return int|null
     */
    public function getCrtFrom(): ?int
    {
        return $this->container['crtFrom'] ?? null;
    }

    /**
     * Set creation start time
     * Timestamp in milliseconds (13 digits)
     *
     * @param int|null $crtFrom
     * @return self
     */
    public function setCrtFrom(?int $crtFrom): self
    {
        $this->container['crtFrom'] = $crtFrom;
        return $this;
    }

    /**
     * Get creation end time
     *
     * @return int|null
     */
    public function getCrtTo(): ?int
    {
        return $this->container['crtTo'] ?? null;
    }

    /**
     * Set creation end time
     * Timestamp in milliseconds (13 digits)
     *
     * @param int|null $crtTo
     * @return self
     */
    public function setCrtTo(?int $crtTo): self
    {
        $this->container['crtTo'] = $crtTo;
        return $this;
    }

    /**
     * Get SKU ID list
     *
     * @return int[]|null
     */
    public function getSkuIdList(): ?array
    {
        return $this->container['skuIdList'] ?? null;
    }

    /**
     * Set SKU ID list
     *
     * @param int[]|null $skuIdList
     * @return self
     */
    public function setSkuIdList(?array $skuIdList): self
    {
        $this->container['skuIdList'] = $skuIdList;
        return $this;
    }

    /**
     * Get category ID list
     *
     * @return int[]|null
     */
    public function getCatIdList(): ?array
    {
        return $this->container['catIdList'] ?? null;
    }

    /**
     * Set category ID list
     * Supports both leaf and non-leaf cat id, supports batch
     *
     * @param int[]|null $catIdList
     * @return self
     */
    public function setCatIdList(?array $catIdList): self
    {
        $this->container['catIdList'] = $catIdList;
        return $this;
    }

    /**
     * Get SKU sub-status filter type
     *
     * @return int|null
     */
    public function getSkuSubStatusFilterType(): ?int
    {
        return $this->container['skuSubStatusFilterType'] ?? null;
    }

    /**
     * Set SKU sub-status filter type
     *
     * @param int|null $skuSubStatusFilterType
     * @return self
     */
    public function setSkuSubStatusFilterType(?int $skuSubStatusFilterType): self
    {
        $this->container['skuSubStatusFilterType'] = $skuSubStatusFilterType;
        return $this;
    }

    /**
     * Get SKU status change time from
     *
     * @return int|null
     */
    public function getSkuStatusChangeTimeFrom(): ?int
    {
        return $this->container['skuStatusChangeTimeFrom'] ?? null;
    }

    /**
     * Set SKU status change time from
     * Timestamp in milliseconds
     *
     * @param int|null $skuStatusChangeTimeFrom
     * @return self
     */
    public function setSkuStatusChangeTimeFrom(?int $skuStatusChangeTimeFrom): self
    {
        $this->container['skuStatusChangeTimeFrom'] = $skuStatusChangeTimeFrom;
        return $this;
    }

    /**
     * Get SKU status change time to
     *
     * @return int|null
     */
    public function getSkuStatusChangeTimeTo(): ?int
    {
        return $this->container['skuStatusChangeTimeTo'] ?? null;
    }

    /**
     * Set SKU status change time to
     * Timestamp in milliseconds
     *
     * @param int|null $skuStatusChangeTimeTo
     * @return self
     */
    public function setSkuStatusChangeTimeTo(?int $skuStatusChangeTimeTo): self
    {
        $this->container['skuStatusChangeTimeTo'] = $skuStatusChangeTimeTo;
        return $this;
    }

    /**
     * Get goods search tags
     *
     * @return int[]|null
     */
    public function getGoodsSearchTags(): ?array
    {
        return $this->container['goodsSearchTags'] ?? null;
    }

    /**
     * Set goods search tags
     * 1-Low traffic, 4-Restricted traffic
     *
     * @param int[]|null $goodsSearchTags
     * @return self
     */
    public function setGoodsSearchTags(?array $goodsSearchTags): self
    {
        $this->container['goodsSearchTags'] = $goodsSearchTags;
        return $this;
    }

    /**
     * Get the response class for this request
     *
     * @return string
     */
    public function getResponseClass(): string
    {
        return $this->responseClass;
    }

    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize(): mixed
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue(): string
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
