<?php
/**
 * GoodsSku
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;
use Temu\ObjectSerializer;

/**
 * GoodsSku Class - Individual SKU item information
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class GoodsSku implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'GoodsSku';

    protected static array $openAPITypes = [
        'goodsName' => 'string',
        'specName' => 'string',
        'thumbUrl' => 'string',
        'goodsId' => 'int',
        'skuId' => 'int',
        'skuSn' => 'string',
        'stock' => 'int',
        'price' => 'string',
        'retailPrice' => '\Temu\Model\RetailPrice',
        'crtTime' => 'int',
        'status4VO' => 'int',
        'subStatus4VO' => 'int',
        'goodsIsOnSale' => 'int',
        'currency' => 'string',
        'skuStatusChangeTime' => 'string',
        'volumeInfo' => '\Temu\Model\VolumeInfo',
        'weightInfo' => '\Temu\Model\WeightInfo',
        'skuShowSubStatus4VO' => 'int',
        'specList' => '\Temu\Model\SpecInfo[]',
        'lowTrafficTag' => 'int',
        'restrictedTrafficTag' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static array $openAPIFormats = [
        'goodsName' => null,
        'specName' => null,
        'thumbUrl' => null,
        'goodsId' => null,
        'skuId' => null,
        'skuSn' => null,
        'stock' => null,
        'price' => null,
        'retailPrice' => null,
        'crtTime' => null,
        'status4VO' => null,
        'subStatus4VO' => null,
        'goodsIsOnSale' => null,
        'currency' => null,
        'skuStatusChangeTime' => null,
        'volumeInfo' => null,
        'weightInfo' => null,
        'skuShowSubStatus4VO' => null,
        'specList' => null,
        'lowTrafficTag' => null,
        'restrictedTrafficTag' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'goodsName' => true,
        'specName' => true,
        'thumbUrl' => true,
        'goodsId' => true,
        'skuId' => true,
        'skuSn' => true,
        'stock' => true,
        'price' => true,
        'retailPrice' => true,
        'crtTime' => true,
        'status4VO' => true,
        'subStatus4VO' => true,
        'goodsIsOnSale' => true,
        'currency' => true,
        'skuStatusChangeTime' => true,
        'volumeInfo' => true,
        'weightInfo' => true,
        'skuShowSubStatus4VO' => true,
        'specList' => true,
        'lowTrafficTag' => true,
        'restrictedTrafficTag' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats(): array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'goodsName' => 'goodsName',
        'specName' => 'specName',
        'thumbUrl' => 'thumbUrl',
        'goodsId' => 'goodsId',
        'skuId' => 'skuId',
        'skuSn' => 'skuSn',
        'stock' => 'stock',
        'price' => 'price',
        'retailPrice' => 'retailPrice',
        'crtTime' => 'crtTime',
        'status4VO' => 'status4VO',
        'subStatus4VO' => 'subStatus4VO',
        'goodsIsOnSale' => 'goodsIsOnSale',
        'currency' => 'currency',
        'skuStatusChangeTime' => 'skuStatusChangeTime',
        'volumeInfo' => 'volumeInfo',
        'weightInfo' => 'weightInfo',
        'skuShowSubStatus4VO' => 'skuShowSubStatus4VO',
        'specList' => 'specList',
        'lowTrafficTag' => 'lowTrafficTag',
        'restrictedTrafficTag' => 'restrictedTrafficTag'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static array $setters = [
        'goodsName' => 'setGoodsName',
        'specName' => 'setSpecName',
        'thumbUrl' => 'setThumbUrl',
        'goodsId' => 'setGoodsId',
        'skuId' => 'setSkuId',
        'skuSn' => 'setSkuSn',
        'stock' => 'setStock',
        'price' => 'setPrice',
        'retailPrice' => 'setRetailPrice',
        'crtTime' => 'setCrtTime',
        'status4VO' => 'setStatus4VO',
        'subStatus4VO' => 'setSubStatus4VO',
        'goodsIsOnSale' => 'setGoodsIsOnSale',
        'currency' => 'setCurrency',
        'skuStatusChangeTime' => 'setSkuStatusChangeTime',
        'volumeInfo' => 'setVolumeInfo',
        'weightInfo' => 'setWeightInfo',
        'skuShowSubStatus4VO' => 'setSkuShowSubStatus4VO',
        'specList' => 'setSpecList',
        'lowTrafficTag' => 'setLowTrafficTag',
        'restrictedTrafficTag' => 'setRestrictedTrafficTag'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static array $getters = [
        'goodsName' => 'getGoodsName',
        'specName' => 'getSpecName',
        'thumbUrl' => 'getThumbUrl',
        'goodsId' => 'getGoodsId',
        'skuId' => 'getSkuId',
        'skuSn' => 'getSkuSn',
        'stock' => 'getStock',
        'price' => 'getPrice',
        'retailPrice' => 'getRetailPrice',
        'crtTime' => 'getCrtTime',
        'status4VO' => 'getStatus4VO',
        'subStatus4VO' => 'getSubStatus4VO',
        'goodsIsOnSale' => 'getGoodsIsOnSale',
        'currency' => 'getCurrency',
        'skuStatusChangeTime' => 'getSkuStatusChangeTime',
        'volumeInfo' => 'getVolumeInfo',
        'weightInfo' => 'getWeightInfo',
        'skuShowSubStatus4VO' => 'getSkuShowSubStatus4VO',
        'specList' => 'getSpecList',
        'lowTrafficTag' => 'getLowTrafficTag',
        'restrictedTrafficTag' => 'getRestrictedTrafficTag'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap(): array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters(): array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters(): array
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName(): string
    {
        return self::$openAPIModelName;
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('goodsName', $data ?? [], null);
        $this->setIfExists('specName', $data ?? [], null);
        $this->setIfExists('thumbUrl', $data ?? [], null);
        $this->setIfExists('goodsId', $data ?? [], null);
        $this->setIfExists('skuId', $data ?? [], null);
        $this->setIfExists('skuSn', $data ?? [], null);
        $this->setIfExists('stock', $data ?? [], null);
        $this->setIfExists('price', $data ?? [], null);
        $this->setIfExists('retailPrice', $data ?? [], null);
        $this->setIfExists('crtTime', $data ?? [], null);
        $this->setIfExists('status4VO', $data ?? [], null);
        $this->setIfExists('subStatus4VO', $data ?? [], null);
        $this->setIfExists('goodsIsOnSale', $data ?? [], null);
        $this->setIfExists('currency', $data ?? [], null);
        $this->setIfExists('skuStatusChangeTime', $data ?? [], null);
        $this->setIfExists('volumeInfo', $data ?? [], null);
        $this->setIfExists('weightInfo', $data ?? [], null);
        $this->setIfExists('skuShowSubStatus4VO', $data ?? [], null);
        $this->setIfExists('specList', $data ?? [], null);
        $this->setIfExists('lowTrafficTag', $data ?? [], null);
        $this->setIfExists('restrictedTrafficTag', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties(): array
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid(): bool
    {
        return count($this->listInvalidProperties()) === 0;
    }

    // Getters and Setters

    public function getGoodsName(): ?string
    {
        return $this->container['goodsName'];
    }

    public function setGoodsName(?string $goodsName): self
    {
        $this->container['goodsName'] = $goodsName;
        return $this;
    }

    public function getSpecName(): ?string
    {
        return $this->container['specName'];
    }

    public function setSpecName(?string $specName): self
    {
        $this->container['specName'] = $specName;
        return $this;
    }

    public function getThumbUrl(): ?string
    {
        return $this->container['thumbUrl'];
    }

    public function setThumbUrl(?string $thumbUrl): self
    {
        $this->container['thumbUrl'] = $thumbUrl;
        return $this;
    }

    public function getGoodsId(): ?int
    {
        return $this->container['goodsId'];
    }

    public function setGoodsId(?int $goodsId): self
    {
        $this->container['goodsId'] = $goodsId;
        return $this;
    }

    public function getSkuId(): ?int
    {
        return $this->container['skuId'];
    }

    public function setSkuId(?int $skuId): self
    {
        $this->container['skuId'] = $skuId;
        return $this;
    }

    public function getSkuSn(): ?string
    {
        return $this->container['skuSn'];
    }

    public function setSkuSn(?string $skuSn): self
    {
        $this->container['skuSn'] = $skuSn;
        return $this;
    }

    public function getStock(): ?int
    {
        return $this->container['stock'];
    }

    public function setStock(?int $stock): self
    {
        $this->container['stock'] = $stock;
        return $this;
    }

    public function getPrice(): ?string
    {
        return $this->container['price'];
    }

    public function setPrice(?string $price): self
    {
        $this->container['price'] = $price;
        return $this;
    }

    public function getRetailPrice(): ?RetailPrice
    {
        return $this->container['retailPrice'];
    }

    public function setRetailPrice(?RetailPrice $retailPrice): self
    {
        $this->container['retailPrice'] = $retailPrice;
        return $this;
    }

    public function getCrtTime(): ?int
    {
        return $this->container['crtTime'];
    }

    public function setCrtTime(?int $crtTime): self
    {
        $this->container['crtTime'] = $crtTime;
        return $this;
    }

    public function getStatus4VO(): ?int
    {
        return $this->container['status4VO'];
    }

    public function setStatus4VO(?int $status4VO): self
    {
        $this->container['status4VO'] = $status4VO;
        return $this;
    }

    public function getSubStatus4VO(): ?int
    {
        return $this->container['subStatus4VO'];
    }

    public function setSubStatus4VO(?int $subStatus4VO): self
    {
        $this->container['subStatus4VO'] = $subStatus4VO;
        return $this;
    }

    public function getGoodsIsOnSale(): ?int
    {
        return $this->container['goodsIsOnSale'];
    }

    public function setGoodsIsOnSale(?int $goodsIsOnSale): self
    {
        $this->container['goodsIsOnSale'] = $goodsIsOnSale;
        return $this;
    }

    public function getCurrency(): ?string
    {
        return $this->container['currency'];
    }

    public function setCurrency(?string $currency): self
    {
        $this->container['currency'] = $currency;
        return $this;
    }

    public function getSkuStatusChangeTime(): ?string
    {
        return $this->container['skuStatusChangeTime'];
    }

    public function setSkuStatusChangeTime(?string $skuStatusChangeTime): self
    {
        $this->container['skuStatusChangeTime'] = $skuStatusChangeTime;
        return $this;
    }

    public function getVolumeInfo(): ?VolumeInfo
    {
        return $this->container['volumeInfo'];
    }

    public function setVolumeInfo(?VolumeInfo $volumeInfo): self
    {
        $this->container['volumeInfo'] = $volumeInfo;
        return $this;
    }

    public function getWeightInfo(): ?WeightInfo
    {
        return $this->container['weightInfo'];
    }

    public function setWeightInfo(?WeightInfo $weightInfo): self
    {
        $this->container['weightInfo'] = $weightInfo;
        return $this;
    }

    public function getSkuShowSubStatus4VO(): ?int
    {
        return $this->container['skuShowSubStatus4VO'];
    }

    public function setSkuShowSubStatus4VO(?int $skuShowSubStatus4VO): self
    {
        $this->container['skuShowSubStatus4VO'] = $skuShowSubStatus4VO;
        return $this;
    }

    /**
     * @return SpecInfo[]|null
     */
    public function getSpecList(): ?array
    {
        return $this->container['specList'];
    }

    /**
     * @param SpecInfo[]|null $specList
     */
    public function setSpecList(?array $specList): self
    {
        $this->container['specList'] = $specList;
        return $this;
    }

    public function getLowTrafficTag(): ?int
    {
        return $this->container['lowTrafficTag'];
    }

    public function setLowTrafficTag(?int $lowTrafficTag): self
    {
        $this->container['lowTrafficTag'] = $lowTrafficTag;
        return $this;
    }

    public function getRestrictedTrafficTag(): ?int
    {
        return $this->container['restrictedTrafficTag'];
    }

    public function setRestrictedTrafficTag(?int $restrictedTrafficTag): self
    {
        $this->container['restrictedTrafficTag'] = $restrictedTrafficTag;
        return $this;
    }

    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    public function offsetGet($offset): mixed
    {
        return $this->container[$offset] ?? null;
    }

    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}