<?php
/**
 * GoodsSaleStatusRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;

/**
 * GoodsSaleStatusRequest Class - Request model for getGoodsSaleStatus API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class GoodsSaleStatusRequest extends BaseRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'GoodsSaleStatusRequest';

    protected static array $openAPITypes = [
        'type' => 'string',
        'goodsIdList' => 'array'
    ];

    protected string $responseClass = GoodsSaleStatusResponse::class;

    public function __construct(array $goodsIdList)
    {
        parent::__construct();
        $this->setType('bg.local.goods.publish.status.get');
        $this->setGoodsIdList($goodsIdList);
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    public function getGoodsIdList(): ?array
    {
        return $this->container['goodsIdList'] ?? null;
    }

    public function setGoodsIdList(array $goodsIdList): self
    {
        $this->container['goodsIdList'] = $goodsIdList;
        return $this;
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }
}
