<?php
/**
 * GoodsRecommendPriceRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;

/**
 * GoodsRecommendPriceRequest Class - Request model for getGoodsRecommendPrice API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class GoodsRecommendPriceRequest extends BaseRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'GoodsRecommendPriceRequest';

    protected static array $openAPITypes = [
        'type' => 'string',
        'recommendedPriceType' => 'int',
        'goodsIdList' => 'array',
        'language' => 'string'
    ];

    protected string $responseClass = GoodsRecommendPriceResponse::class;

    public function __construct(int $recommendedPriceType, array $goodsIdList, string $language)
    {
        parent::__construct();
        $this->setType('temu.local.goods.recommendedprice.query');
        $this->setRecommendedPriceType($recommendedPriceType);
        $this->setGoodsIdList($goodsIdList);
        $this->setLanguage($language);
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    public function getRecommendedPriceType(): ?int
    {
        return $this->container['recommendedPriceType'] ?? null;
    }

    public function setRecommendedPriceType(int $recommendedPriceType): self
    {
        $this->container['recommendedPriceType'] = $recommendedPriceType;
        return $this;
    }

    public function getGoodsIdList(): ?array
    {
        return $this->container['goodsIdList'] ?? null;
    }

    public function setGoodsIdList(array $goodsIdList): self
    {
        $this->container['goodsIdList'] = $goodsIdList;
        return $this;
    }

    public function getLanguage(): ?string
    {
        return $this->container['language'] ?? null;
    }

    public function setLanguage(string $language): self
    {
        $this->container['language'] = $language;
        return $this;
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }
}
