<?php
/**
 * GoodsPriceOrderRequest
 * PHP version 8.1
 *
 * @category Class
 * @package  Temu
 * @author   Temu SDK Generator
 */

namespace Temu\Model;

use ArrayAccess;

/**
 * GoodsPriceOrderRequest Class - Request model for getGoodsPriceOrder API
 *
 * @category Class
 * @package  Temu
 * @implements \ArrayAccess<string, mixed>
 */
class GoodsPriceOrderRequest extends BaseRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    protected static string $openAPIModelName = 'GoodsPriceOrderRequest';

    protected static array $openAPITypes = [
        'type' => 'string',
        'page' => 'int',
        'size' => 'int',
        'priceOrderType' => 'int',
        'goodsId' => 'int'
    ];

    protected string $responseClass = GoodsPriceOrderResponse::class;

    public function __construct(int $page, int $size, int $priceOrderType, ?int $goodsId = null)
    {
        parent::__construct();
        $this->setType('bg.local.goods.priceorder.query');
        $this->setPage($page);
        $this->setSize($size);
        $this->setPriceOrderType($priceOrderType);
        if ($goodsId !== null) {
            $this->setGoodsId($goodsId);
        }
    }

    public static function openAPITypes(): array
    {
        return self::$openAPITypes;
    }

    public function getPage(): ?int
    {
        return $this->container['page'] ?? null;
    }

    public function setPage(int $page): self
    {
        $this->container['page'] = $page;
        return $this;
    }

    public function getSize(): ?int
    {
        return $this->container['size'] ?? null;
    }

    public function setSize(int $size): self
    {
        $this->container['size'] = $size;
        return $this;
    }

    public function getPriceOrderType(): ?int
    {
        return $this->container['priceOrderType'] ?? null;
    }

    public function setPriceOrderType(int $priceOrderType): self
    {
        $this->container['priceOrderType'] = $priceOrderType;
        return $this;
    }

    public function getGoodsId(): ?int
    {
        return $this->container['goodsId'] ?? null;
    }

    public function setGoodsId(?int $goodsId): self
    {
        $this->container['goodsId'] = $goodsId;
        return $this;
    }

    public function getResponseClass(): string
    {
        return $this->responseClass;
    }
}
